/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *  vZbTˑW[iMIPS3pj
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ݃nh^݃}XN̋[e[u
 */
INT_TABLE int_table[ TMAX_ALL_INTNO ];

/*
 *  Onh̋[e[u
 */
FP exc_table[ TMAX_CORE_EXCNO ];

/*
 *  vZbTˑ̏
 */
void cpu_initialize() {

	int i;

	/* ݃nh^݃}XN̋[e[u */
	for( i = 0; i < TMAX_ALL_INTNO; i++ ) {
		define_inh( i, (FP) &cpu_experr );
	}

	/* OxN^̋[e[u */
	for( i = 0; i < TMAX_CORE_EXCNO; i++ ) {
		define_exc( i, (FP) &cpu_experr );
	}

}

/*
 *  vZbTˑ̏I
 */
void cpu_terminate() {
}

/*
 *  ԑ҂
 */
void sil_dly_nse(UINT dlytim) {

	/* $2 : v0, $3 : v1 */
	Asm("	move	$2, %0" :: "r"(dlytim) );
	Asm("	li	$3, %0" :: "g"(SIL_DLY_TIM1) );

	Asm("	sub	$2, $2, $3");	/* v0 -= v1 (dlytim -= SIL_DLY_TIM1) */
	Asm("	blez    $2, sil_dly_nse_2");	/* v0 <= 0 Ȃ烊^[ */

	Asm("	li      $3, %0" :: "g"(SIL_DLY_TIM2) );

	Asm("sil_dly_nse_1:");
	Asm("	sub     $2, $2, $3");	/* v0 -= v1 (dlytim -= SIL_DLY_TIM2) */
	Asm("	bgtz    $2, sil_dly_nse_1");	/* v0 > 0 Ȃ烋[v */

	Asm("sil_dly_nse_2:");
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *  ݃}XŃA^XNfBXpb`ɂāAVsԂɂȂ^XN
 *  pB̂߁A^XNsɁAʂ̃^XNɂĊ݃}XN
 *  ύXꍇBJSPJ[lł́A݃}XN̕ύX̓^XNO
 *  [`ɂĂN邪AɂĈȂ󋵂͏ȂƎv
 *  B݃}XN̒lɂă^XNfBXpb`֎~ꍇɂ́A
 *  dis_dsp 𕹗p΂悢B
 *  MIPS3^[Qbgł́AMIPS3RÅ݃}XNłȂA݃Rg[
 *  ̊݃Rg[Ă̂ŒӁB
 */

SYSCALL ER chg_ipm(IPM ipm) {

	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_IPM(ipm);

	t_lock_cpu();
	cpu_set_ipm( ipm.core );	/* MIPS3RÅ݃}XN̐ݒ */
	icu_set_ipm( &(ipm.icu) );	/* O݃Rg[̊݃}XN
					   ̐ݒ */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER get_ipm(IPM *p_ipm) {

	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	p_ipm->core = cpu_get_ipm();	/* MIPS3RÅ݃}XNQ */
	icu_get_ipm(&(p_ipm->icu));	/* O݃Rg[̊݃}XN
					   ̎Q */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 * nho^ĂȂ݁EOƌĂяo
 */
void cpu_experr( EXCSTACK *sp, UW SR, UW CR) {

    syslog_0(LOG_EMERG, "Interrupt/Exception error occurs.");

    syslog_1(LOG_EMERG, "PC(EPC;CP0_r14) = 0x%08x",
    			sp->CP0_EPC);
    syslog_2(LOG_EMERG, "SR(Status;CP0_r12) = 0x%08x CR(Cause;CP0_r13) = 0x%08x",
    			SR, CR);	/* SRłAsp->CP0_Statusł */
    syslog_3(LOG_EMERG, "at(r1 ) = %08x v0(r2 ) = %08x v1(r3 ) = %08x",
    			sp->at, sp->v0, sp->v1);
    syslog_4(LOG_EMERG, "a0(r4 ) = %08x a1(r5 ) = %08x a2(r6 ) = %08x a3(r7 ) = %08x",
    			sp->a0, sp->a1, sp->a2, sp->a3);
    syslog_4(LOG_EMERG, "t0(r8 ) = %08x t1(r9 ) = %08x t2(r10) = %08x t3(r11) = %08x",
    			sp->t0, sp->t1, sp->t2, sp->t3);
    syslog_4(LOG_EMERG, "t4(r12) = %08x t5(r13) = %08x t6(r14) = %08x t7(r15) = %08x",
    			sp->t4, sp->t5, sp->t6, sp->t7);
    syslog_2(LOG_EMERG, "t8(r24) = %08x t9(r25) = %08x",
    			sp->t8, sp->t9);
    syslog_2(LOG_EMERG, "HI = %08x LO = %08x",
    			sp->hi, sp->lo);
    syslog_4(LOG_EMERG, "gp(r28) = %08x sp(r29) = %08x fp(r30) = %08x ra(r31) = %08x",
    			sp->gp, sp->sp, sp->fp, sp->ra);
    while(1);
}

/*
 *  ubN색CuiNXNvgŎgpj
 *	(ItIs̗p)
 *
 *  ֐̎dĺCANSI C Cu̎dlƓDWCû̂
 *  gǂ\D
 */
VP _dummy_memcpy(VP dest, VP src, UINT len) {

	VB	*d = dest;
	VB	*s = src;

	while (len-- > 0) {
		*d++ = *s++;
	}

	return(dest);
}
