/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#define _MACRO_ONLY
#include <microblaze_asm.inc>
#include <t_config.h>
#include <sys_defs.h>
/*
 *  # 0x00 #		Imm instr for reset address     [Hi halfword]
 *  # 0x04 #		Jump to _start                  [Lo halfword]
 *  # 0x08 #		Imm instr for exception address [Hi halfword]
 *  # 0x0c #		Jump to Exception handler       [Lo halfword]
 *  # 0x10 #		Imm instr for interrupt address [Hi halfword]
 *  # 0x14 #		Jump to interrupt handler       [Lo halfword]
 */

        
	.text
	.global _start
	.align  2
    .ent _start
_start:
    /*
     *  msr
     */
    la   r1, r0, MSR_CACHE_SETTING         
    mts  rmsr,r1 
                
    /*
     *  opb_mdm g msr BIPrbg'1'Ŏs邽߁C
     *  rtbd߂ɂ'0'ɏD
     *  stub gꍇ͕KvȂɕpȂ߁CɎsD
     */
    la    r1, r0, _start_
    rtbd  r1,0
_start_:        
               
    /*
     * R2R3̐ݒ
     *ER2  : Read-only small data area anchor
     *   _SDA2_BASE_ .sdata2̒S
     *ER13 : Read-write small data area anchor
     *   .sdatasbssAĒuC̒Ԃ_SDA_BASE_ ݒ肷
     */
	la	r13, r0, _SDA_BASE_
	la	r2,  r0, _SDA2_BASE_

	/*
	 * X^bN|C^̏
	 */
	la	r1, r0, STACKTOP - 4

   /*
	* xN^e[ȕ
	*/
	/*
     *  brai ߂̏
     */
	la  r3,  r0,  0xb8080000  /* brai ̃IyR[h      */
	swi r3,  r0,  0xc         /* exceptionxN^֓o^  */
	swi r3,  r0,  0x14        /* interrruptxN^֓o^ */
	/*
     * imm ߂̏
     */
	la  r4,  r0,  0xb0000000  /* imm ̃IyR[h       */
	swi r4,  r0,  0x8         /* exceptionxN^֓o^  */
    swi r4,  r0,  0x10        /* interrruptxN^֓o^ */

	/*
     *  Onh̓o^
     */
	la   r5,  r0,  exception_entry
	sw	 r5,  r1,  r0
	lhu  r6,  r1,  r0
	shi	 r5,  r0,  0xe       /* ݃nh16bit */
	shi	 r6,  r0,  0xa       /* ݃nh16bit */

	/*
	 *  ݃nh̓o^
	 */
	la   r5,  r0,  interrupt_entry
	sw	 r5,  r1,  r0
	lhu  r6,  r1,  r0
	shi	 r5,  r0,  0x16      /* ݃nh16bit */
	shi	 r6,  r0,  0x12      /* ݃nh16bit */


	/*
	 *  _hardware_init_hook ĂяoB(0łȂꍇ)
	 *
	 *  n[hEFAˑɕKvȏꍇ́C
	 *  hardware_init_hook Ƃ֐pӂ΂悢D
	 *  ̓IɂROM̍ہARAMgp\ɂ邽߂
	 *  oXRg[̏sB
	 *  sys_support.S  _hardware_init_hook `Ă
	 *  D
	 */
start_0:
	la    r3,  r0,  _hardware_init_hook
	beqi  r3,  start_1
	brald r15, r3
	nop


	/*
     *  bssZNVNA
     */
start_1:
	la    r3,  r0,  __bss_start
	la    r4,  r0,  _end
	sub   r5,  r4,  r3
	beqi  r5,  start_3
start_2:
	sb    r0,  r0,  r3
	addi  r3,  r3,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_2

	/*
	 *  dataZNV̏iROMΉj
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
     *  Microblaze͓RAMƂƁCBRAM̓e
     *  RtBM[VƏ邽
     *  dataZNV͍̏sȂ
     *  ꍇɂĂ͎邱Ƃlăx̂ݒ`Ă
	 */
start_3:
	la    r3,  r0,  __idata_start
	la    r4,  r0,  __idata_end
	sub   r5,  r4,  r3     /* TCY`FbN */
	beqi  r5,  start_5
	la    r6,  r0,  __data_start
start_4:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_4


start_5:
	la    r3,  r0,  __isdata2_start
	la    r4,  r0,  __isdata2_end
	sub   r5,  r4,  r3     /* TCY`FbN */
	beqi  r5,  start_7
	la    r6,  r0,  __sdata2_start
start_6:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_6


start_7:
	la    r3,  r0,  __isdata_start
	la    r4,  r0,  __isdata_end
	sub   r5,  r4,  r3     /* TCY`FbN */
	beqi  r5,  start_9
	la    r6,  r0,  __sdata_start
start_8:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_8


	/*
	 *  _software_init_hook Ăяoi0 łȂꍇjD
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
start_9:
	la    r3,  r0,  _software_init_hook
	beqi  r3,  start_10
	brald r15, r3
	nop

start_10:
	brlid	r15, kernel_start
    addik r1,r1,4            /* X^bNɖ߂ */
