/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  vZbTɈˑ`iMicroblazepj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

//#include "microblaze.h"

#ifndef MICROBLAZE
#define MICROBLAZE   /* vZbT */
#endif 
/*
 *  vZbTɈˑ`
 */
#ifndef _MACRO_ONLY

typedef	UINT		INHNO;		/* ݃nhԍ */
typedef	UINT		IPM;		/* ݃}XN */
typedef	UINT		EXCNO;		/* CPUOnhԍ */


/*
 *  INTNO^Ɗ݂̋֎~/
 */

typedef	UINT		INTNO;		/* ݔԍ */

extern ER	dis_int(INTNO intno) throw(); 
extern ER	ena_int(INTNO intno) throw();


/*
 *  ^[QbgVXeˑ̃T[rXR[
 */
typedef	UW  SYSUTIM;	/* \]pVXe */
extern  ER   vxget_tim(SYSUTIM *pk_sysutim) throw();


/*
 *  MSR̃rbg
 */
#define MSR_IE 0x02
#define MSR_BE 0x01


/*
 *  ׂĂ݂̊֎~
 */
Inline void
_disint_()
{
    UW msr;
  
    Asm("mfs %0,rmsr": "=r"(msr));
    msr &= ~MSR_IE;
    Asm("mts rmsr,%0" : : "r"(msr));
}


/*
 *  ݂
 */
Inline void
_enaint_()
{
    UW msr;
    
    Asm("mfs %0,rmsr": "=r"(msr));
    msr |= MSR_IE;
    Asm("mts rmsr,%0" : : "r"(msr));    
}


/*
 *  ݃bNԂ̐
 */
#define SIL_PRE_LOC 
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _enaint_()

/*
 * VXe̒f
 */
Inline void
kernel_abort()
{
    Asm("brki r16 0x20");
}

/*
 *  ԑ҂
 */
Inline void
sil_dly_nse(UINT dlytim)
{
    Asm("add r5, r0, %0; \
         brlid r15, _sil_dly_nse; \
         nop\n"
        : 
        : "r"(dlytim)
        : "r15", "r5");
    
}


#endif /* _MACRO_ONLY */

/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN  SIL_ENDIAN_BIG  /* rbNGfBA */


#endif /* _CPU_DEFS_H_ */
