/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 *	VAI/OfoCXiSIOjhCoiDVE68K/40pj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <dve68k_dga.h>
#ifndef _MACRO_ONLY
#include <upd72001.h>
#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO	TVEC_GP0

#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize	upd72001_initialize

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  I[v|[g邩 openflag ɓǂłD
	 */
	openflag = upd72001_openflag();

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = upd72001_opn_por(siopid, exinf);

	/*
	 *  VAI/O݂̊݃xݒ肵C}XND
	 */
	if (!openflag) {
		dga_set_ilv((VP) TADR_DGA_CSR25, TBIT_GP0IL, TIRQ_LEVEL6);
		dga_bit_or((VP) TADR_DGA_CSR21, TBIT_GP0);
	}
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	upd72001_cls_por(siopcb);

	/*
	 *  VAI/O݂}XND
	 */
	if (!upd72001_openflag()) {
		dga_bit_and((VP) TADR_DGA_CSR21, ~TBIT_GP0);
	}
}

/*
 *  SIO̊݃nh
 */
#define	sio_handler	upd72001_isr

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr	upd72001_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr	upd72001_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr	upd72001_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr	upd72001_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define	sio_ierdy_snd	upd72001_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define	sio_ierdy_rcv	upd72001_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
