/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *	^[Qbgˑ^C}W[iM32R ^C}(MFT0)pj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#define WAIT __asm("nop;nop;nop;nop");

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER 21 //INT_MFT0(16) + TIMER_PORT(5)

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UW	CLOCK;

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
	*(volatile unsigned short *)(ICUCR(MFT,TIMER_PORT)+2) = 0x1000;
	*(volatile unsigned short *)(MFTMOD(TIMER_PORT)+2) = 0x8000;
	*(volatile unsigned short *)(MFTCUT(TIMER_PORT)+2) = TIMER_CLKCNT;
	*(volatile unsigned short *)(MFTCR+2) = 0x8080 >> TIMER_PORT;
}

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{	
	*(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) = 0x10;	
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate()
{	
	*(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) = 0x0;	
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return *(volatile unsigned short *)(MFTCUT(TIMER_PORT)+2);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{	return *(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) & 0x1;	}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */

