/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	^C}hCoiOAKS16pj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <sil.h>
#include <oaks16.h>

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	       INT_TA0

/*
 *  ^C}[̊荞݃x
 */

#define INT_LEVEL_TIMER	0x05

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UH	CLOCK;

/*
 *  ^C}l̓\ƃ~bPʂƂ̕ϊ
 *
 *  1ms̃^C}[荞݂gp̂ł̃NbN`D
 */
#define TIMER_CLOCK		16000
#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  \]pVXeoۂ̏Ԃ̌ςliPʂ͓\j
 */
#define	GET_TOLERANCE	100	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize(void)
{
		/* ^C} */
	sil_wrb_mem((VP)TADR_SFR_TABSR, 0x00);		/* ^C}JEg~  */
	sil_wrb_mem((VP)TADR_SFR_UDF, 0x00);		/* _EJEgݒ				*/
	sil_wrb_mem((VP)TADR_SFR_TA0MR, 0x00);		/*  JEg\[Xf1, ^C}[h  */
	/*
	 *  ^C} 1ms TIMER_CLOCK JEg,
	 *  WX^ݒl̓}CiX1.
	 */
	sil_wrh_mem((VP)TADR_SFR_TA0, TIMER_CLOCK-1);/* ^C}l̏				*/
												/* 荞݃x̐ݒ				*/
	set_ic_ilvl((VP)(TADR_SFR_INT_BASE+TADR_SFR_TA0IC_OFFSET), INT_LEVEL_TIMER);
												/* JEgJn						*/
	sil_wrb_mem((VP)TADR_SFR_TABSR, TBIT_TABSR_TA0S);
}

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear(void)
{
	/*
	 *  ̊֐̓^C}荞݃nh
	 *  isig_tim ĂяoOɎs.
	 *  ݂󂯕tĂ
	 *  ݃nhɏڂ_
	 *  ݗvrbg̓NA邽
	 *  KvȂ. 
	 */
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate(void)
{
	VB  c;

	c = sil_reb_mem((VP)TADR_SFR_TABSR);
	c &= ~TBIT_TABSR_TA0S;						/* JEgI						*/
	sil_wrb_mem((VP)TADR_SFR_TABSR, c);
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return (TIMER_CLOCK-1)-sil_reh_mem((VP)TADR_SFR_TA0);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)(TADR_SFR_INT_BASE+TADR_SFR_TA0IC_OFFSET)) & TBIT_TAiIC_IR) != 0;
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
