/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *	VAI/OfoCXiSIOjhCoiH8St@~[pj
 */
#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <h8s_sci.h>

/*
 *  SIO̊݃nh̃xN^ԍ
 */
/* |[gP */
#define INHNO_SERIAL1_ERROR	IRQ_ERI0
#define INHNO_SERIAL1_IN	IRQ_RXI0
#define INHNO_SERIAL1_OUT	IRQ_TXI0
#if TNUM_PORT >= 2
/* |[gQ */
#define INHNO_SERIAL2_ERROR	IRQ_ERI1
#define INHNO_SERIAL2_IN	IRQ_RXI1
#define INHNO_SERIAL2_OUT	IRQ_TXI1
#endif /* TNUM_PORT */

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize		h8s_sci_initialize

/*
 *  J[lNp̏ (sys_putcŗp)
 */
#define sio_init		h8s_sci_init

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  I[v|[g邩 openflag ɓǂłB
	 */
	openflag = h8s_sci_openflag();

	/*
	 * W[Xgbv[h
	 */
#if TNUM_SIOP < 2
	h8s_andh( (VP) MSTPCR, ~( BIT5 ) );
#else /* TNUM_SIOP < 2 */
	h8s_andh( (VP) MSTPCR, ~( BIT6 | BIT5 ) );
#endif /* TNUM_SIOP < 2 */

	/*
	 *  foCXˑ̃I[v
	 */
	siopcb = h8s_sci_opn_por(siopid, exinf);

	/*
	 *  VAI/O݂̊݃xݒ肷B
	 */
	if (!openflag) {
		/* ݃xݒ */
#ifndef GDB_STUB	/* SCI0  GDB_STUB ŗpB */
		icu_set_ilv( (VP) IPRJ, IPR_LOW, SCI0_INT_LVL );
#endif /* GDB_STUB */
#if TNUM_SIOP >= 2
		icu_set_ilv( (VP) IPRK, IPR_UPR, SCI1_INT_LVL );
#endif /* TNUM_SIOP >= 2 */
	}
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[Y
	 */
	h8s_sci_cls_por(siopcb);

	/*
	 *  W[Xgbv[hZbg
	 */
#if TNUM_SIOP < 2
	h8s_orh( (VP) MSTPCR,   BIT5 );
#else /* TNUM_SIOP < 2 */
	h8s_orh( (VP) MSTPCR, ( BIT6 | BIT5 ) );
#endif /* TNUM_SIOP < 2 */

	/*
	 *  VAI/O݂}XNB
	 */
	if (!h8s_sci_openflag()) {
		/* ݃}XN */
#ifndef GDB_STUB	/* SCI0  GDB_STUB ŗpB */
		icu_set_ilv( (VP) IPRJ, IPR_LOW, 0 );
#endif /* GDB_STUB */
#if TNUM_SIOP >= 2
		icu_set_ilv( (VP) IPRK, IPR_UPR, 0 );
#endif /* TNUM_SIOP >= 2 */
	}
}

#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh
 *    sio1_handler_in    : M݃nh
 *    sio1_handler_out   : M݃nh
 *    sio1_handler_error : MG[݃nh
 */
/* |[gP */
#define	sio1_handler_in		h8s_sci0_isr_in
#define	sio1_handler_out	h8s_sci0_isr_out
#define	sio1_handler_error	h8s_sci0_isr_error
#if TNUM_SIOP >= 2
/* |[gQ */
#define	sio2_handler_in		h8s_sci1_isr_in
#define	sio2_handler_out	h8s_sci1_isr_out
#define	sio2_handler_error	h8s_sci1_isr_error
#endif /* TNUM_SIOP >= 2 */

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr		h8s_sci_snd_chr

/*
 *  VAI/O|[gւ̕Mi|[Oj
 */
#define	sio_snd_chr_pol		h8s_sci0_putchar_pol

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr		h8s_sci_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr		h8s_sci_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr		h8s_sci_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define	sio_ierdy_snd		h8s_sci_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define	sio_ierdy_rcv		h8s_sci_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
