/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _MINET_H8S_2339F_H_
#define _MINET_H8S_2339F_H_

/*
 *  MiSPO MiNET-H8S/2339Fp`
 */

#define MINET_H8S_2339F

/*
 *  SYSCȐl
 *  @EINTM1=1,INTM0=0Fݐ䃂[hQ
 *  @ENMIEG=0FNMI̗͂GbWŊ荞ݗv𔭐
 *  @EIRQPASFIRQ͒[qZNg
 *  @ERAME=1FRAML
 */
#define	SYS_SYSCR	(INT_MODE2 | RAME)

/*
 *  CPU NbN
 */
#define CPU_CLOCK	24576			/* kHzP i24.576MHzj*/

/*
 *  ^C}ɋNbN (NbN/4ŃJEg)
 */
#define TIMER_CLOCK	((CPU_CLOCK)/4)		/* kHzP */

/*
 *  VA|[gBRRWX^l̒`
 *    vZp@邪A덷̔肪KvȂ̂ŁA
 *@@ʂɃ}N`ĂB
 *@@BRR_RATE}N̓}jANɑΉB
 *@@n=0łB
 *@@BAUD_RATEuser_config.hŒ`B
 */
#if CPU_CLOCK != 24576
#error CPU_CLOCK is invalid value.
#else /*  CPU_CLOCK != 24576  */

/*  SCI0  */
#if BAUD_RATE0 == 9600		/* rbg[gF 9600[bps] */
	#define BRR0_RATE	79
#elif BAUD_RATE0 == 19200	/* rbg[gF19200[bps] */
	#define BRR0_RATE	39
#elif BAUD_RATE0 == 38400	/* rbg[gF38400[bps] */
	#define BRR0_RATE	19
#endif /* BAUD_RATE0 == 9600  */

/*  SCI1  */
#if BAUD_RATE1 == 9600		/* rbg[gF 9600[bps] */
	#define BRR1_RATE	79
#elif BAUD_RATE1 == 19200	/* rbg[gF19200[bps] */
	#define BRR1_RATE	39
#elif BAUD_RATE1 == 38400	/* rbg[gF38400[bps] */
	#define BRR1_RATE	19
#endif /* BAUD_RATE1 == 9600  */

/*  SCI1  */
#if BAUD_RATE2 == 9600		/* rbg[gF 9600[bps] */
	#define BRR2_RATE	79
#elif BAUD_RATE2 == 19200	/* rbg[gF19200[bps] */
	#define BRR2_RATE	39
#elif BAUD_RATE2 == 38400	/* rbg[gF38400[bps] */
	#define BRR2_RATE	19
#endif /* BAUD_RATE1 == 9600  */

/*
 *  SCRWX^CKS0,CKS1rbg
 *@@{[[gvZn=0ɑΉ
 *@@{[[gɒlقȂꍇ̂Œ
 */
#define SCR0_CKS		0	/*  SCI0  */
#define SCR1_CKS		0	/*  SCI1  */
#define SCR2_CKS		0	/*  SCI2  */

#endif /* CPU_CLOCK != 24576 */

/*
 *  DDRWX^̏l̒`
 */
#define P1DDR0		0xf0
#define P2DDR0		DUMMY
#define P3DDR0		DUMMY
/*  |[gSDDRȂ߁A  */
#define P5DDR0		DUMMY
#define P6DDR0		0xc3
#define P7DDR0		DUMMY
#define P8DDR0		DUMMY
#define P9DDR0		0xe0
#define PADDR0		0xff
#define PBDDR0		0xff
#define PCDDR0		0xff
#define PDDDR0		DUMMY
#define PEDDR0		DUMMY
#define PFDDR0		0xff
#define PGDDR0		0x1f




#endif /* _MINET_H8S_2339F_H_ */
