/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: h8s_sil.c,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 * VXeC^tF[XCiǉj
 *@@I/O|[g̃f[^EfBNVEWX^DDRւ̃ANZX
 *@@H8SDDR͏ݐpłÂ܂܂ł͏]̃rbg
 *@@ύX邱ƂłȂBibset,bclr߂łsj
 *@@̂߁A{ł́AɃe|pӂāADDR
 *@@ݒlێ@̂ĂB
 *@@
 *@@|[gSDDR͂Ȃ߁AԂɂĂB
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*  ̃e|̈  */
static UB ddr_tmp[] = {
        P1DDR0, P2DDR0, P3DDR0, P5DDR0, 	/*  |[gS͌  */
        P6DDR0, P7DDR0, P8DDR0, P9DDR0, 
        PADDR0, PBDDR0, PCDDR0, PDDDR0, PEDDR0, 
        PFDDR0, PGDDR0
};

/*  
 *@e|[g̃AhX  
 *@@@AhX̉16rbgێB
 */
static const UH ddr_adr[] = {
        P1DDR, P2DDR, P3DDR, P5DDR,  		/*  |[gS͌  */
        P6DDR, P7DDR, P8DDR, P9DDR, 
        PADDR, PBDDR, PCDDR, PDDDR, PEDDR,
        PFDDR, PGDDR
};


/*
 *      DDR̓ǂݏo
 */
UB sil_reb_ddr(IO_PORT_ID port)
{
	assert(port <= TNUM_IO_PORT);
	return ddr_tmp[port];
}

/*
 *      DDȐ
 */
void sil_wrb_ddr(IO_PORT_ID port, UB data)
{
	assert(port <= TNUM_IO_PORT);
	ddr_tmp[port] = data;
	h8s_wrb_reg(ddr_adr[port], (VB)data);
}

/*
 *      DDRANDZ
 */
void sil_anb_ddr(IO_PORT_ID port, UB data)
{
	UB ddr = sil_reb_ddr(port);
        
	ddr &= data;
	sil_wrb_ddr(port, ddr);
}

/*
 *      DDRORZ
 */
void sil_orb_ddr(IO_PORT_ID port, UB data)
{
	UB ddr = sil_reb_ddr(port);

	ddr |= data;
	sil_wrb_ddr(port, ddr);
}

