/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *  H8SSCIp ȈSIOhCo
 *  EĹAQ`lpɋLqĂBH8SV[Y̒ɂ́AR`l
 *    ȏT|[gĂ`bv邪ÂƂ̑Ή͗eՂłB
 */

#include <h8s_sci.h>

/* SCIWX^̃AhX */
/* x[XAhX */
#define SCI0_BASE_ADDR	0xff78	/* `lO */
#define SCI1_BASE_ADDR	0xff80	/* `lP */
#define SCI2_BASE_ADDR	0xff88	/* `lQ */

/* WX^ItZbg */
#define SMR		0	/* VA[hWX^ */
#define BRR		1	/* rbg[gWX^ */
#define SCR		2	/* VARg[WX^ */
#define TDR		3	/* gX~bgf[^WX^ */
#define SSR		4	/* VAXe[^XWX^ */
#define RDR		5	/* V[uf[^WX^ */
#define SCMR		6	/* X}[gJ[h[hWX^ */

/* eWX^̃rbgp^[ */

/* RSR, RDR, TSR, TDR */
/* `ׂ̂́Aɖ */

/* SMR */
#define CA	BIT7
#define	CHR	BIT6	/* 8bit = 0 / 7bit = 1 */
#define	PE	BIT5	/* Parity OFF = 0 / Parity ON = 1 */
#define	OE	BIT4	/* EVEN Parity = 0 / ODD Parity = 1 */
#define	STOP	BIT3	/* 1 STOP BIT = 0 / 2 STOP BIT = 1 */
#define MP	BIT2
#define	CSK1	BIT1
#define	CSK0	BIT0

/*
 *@SMȐl
 *
 *@rbg7=0F[h
 *@rbg6=0FLN^OX=8rbg
 *@rbg5=0FpeB̕tA`FbN֎~
 *@rbg4@FpeB[higpj
 *@rbg3=0FXgbvrbgOX1rbg
 *@rbg1,0F{[[gWFl[^ւ̃NbN\[XI
 *@@@@@@@{[hˑSCRn_CKSƂĒ`inchԍj
 */
#define SMR_INIT	0

/* SCR */
#define TIE	BIT7
#define	RIE	BIT6
#define	TE	BIT5
#define	RE	BIT4
#define	MPIE	BIT3
#define TEIE	BIT2
#define	CKE1	BIT1
#define	CKE0	BIT0

/* SSR */
#define TDRE	BIT7
#define	RDRF	BIT6
#define	ORER	BIT5
#define	FER	BIT4
#define	PER	BIT3
#define TEND	BIT2
#define	MPB	BIT1
#define	MPBT	BIT0


/* 
 * TNUM_PORT : VAhCoiserial.cjA܂ GDICxŃT|[g
 * @@@@@@VA|[g̐ 
 * TNUM_SIOP : PDICxivZbTSIOjŃT|[gVAI/O|[g
 *@@@@@@ ̐i݂̎ł͍ő3j
 *  
 *@user_config.hŒ`B
 */

/* ȉŁAWX^̃AhXAUW ^փLXgĂB́Ax[X
   AhXɃItZbglāAŏIIȃWX^̃AhX߂Ă
   ߂łB擾ɁAŏII VP ^ɃLXgĂB(h8s_sci.h) */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UW	reg_base;	/* WX^̃x[XAhX */
	UH	boud_rate;	/* {[[g[bps]@*/
	UB	boud_brr_def;	/* BRR ݒli{[[g̐ݒlj */
	UB	smr_def;	/* SMR ݒl
				   (MrbgAXgbvrbgCpeB) */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
	BOOL		getready;	/* M */
	BOOL		putready;	/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (UW)SCI0_BASE_ADDR,
	  (UH)BAUD_RATE1,
	  (UB)BRR0_RATE,			/* N l */
	  (UB)(SMR_INIT | (SCR0_CKS & (CKE1 | CKE0)))
	},
#if TNUM_SIOP >= 2
	{ (UW)SCI1_BASE_ADDR,
	  (UH)BAUD_RATE1,
	  (UB)BRR1_RATE,			/* N l */
	  (UB)(SMR_INIT | (SCR1_CKS & (CKE1 | CKE0)))
	}
#endif /* TNUM_SIOP >= 2 */
#if TNUM_SIOP >= 3
	,{(UW)SCI2_BASE_ADDR,
	  (UH)BAUD_RATE2,
	  (UB)BRR2_RATE,			/* N l */
	  (UB)(SMR_INIT | (SCR2_CKS & (CKE1 | CKE0)))
	}
#endif /* TNUM_SIOP >= 3 */
};

/*
 *  VAI/O|[gubN̎o
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SCIpVXeC^tF[XC
 *
 *   base : |[g̃x[XAhX
 *   offset : WX^ItZbg
 *   val : WX^l 
 */
#define h8s_sci_wrb( base, offset, val ) h8s_wrb_reg( (base) + (offset), (val) )
#define h8s_sci_reb( base, offset )	h8s_reb_reg( (base) + (offset) )

/*
 *  SCIpWX^֐
 */
Inline void
h8s_sci_or( const SIOPINIB *siopinib, INT offset, INT val )
{
	UB reg = h8s_sci_reb( siopinib->reg_base, offset );
	h8s_sci_wrb( siopinib->reg_base, offset, reg | (UB)val );
}

Inline void
h8s_sci_and( const SIOPINIB *siopinib, INT offset, INT val )
{
	UB reg = h8s_sci_reb( siopinib->reg_base, offset );
	h8s_sci_wrb( siopinib->reg_base, offset, reg & (UB)val );
}

/*
 *  Mł邩H
 */
Inline BOOL
h8s_sci_getready(SIOPCB *siopcb)
{
	UB ssr;
	
	siopcb->getready = FALSE;
	ssr =  h8s_sci_reb( siopcb->siopinib->reg_base, SSR );
	if( ssr & RDRF ) {
		siopcb->getready = TRUE;
	}
	return( siopcb->getready );
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
h8s_sci_putready(SIOPCB *siopcb)
{
	siopcb->putready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, SSR ) & TDRE ) {
		siopcb->putready = TRUE;
	}
	return( siopcb->putready );
}

/*
 *  M̎o
 */
Inline char
h8s_sci_getchar(SIOPCB *siopcb)
{
	/* RDRFNA */
	h8s_sci_and( siopcb->siopinib, SSR, ~RDRF );

	return( (char) h8s_sci_reb( siopcb->siopinib->reg_base, RDR ) );
}

/*
 *  M镶̏
 */
Inline void
h8s_sci_putchar(SIOPCB *siopcb, char c)
{
	h8s_sci_wrb( siopcb->siopinib->reg_base, TDR, c );

	/* TDRENA */
	h8s_sci_and( siopcb->siopinib, SSR, ~TDRE );
}

/*
 *  SIOhCȍ[`
 */
void
h8s_sci_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  SIOWX^[`
 */
void
h8s_sci_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * SCIWX^̏
	 */

	/* M~ */
	h8s_sci_and( siopinib, SCR, ~( TE | RE ) );

	/* rbgȂǐݒ */
	h8s_sci_wrb( siopinib->reg_base, SMR, siopinib->smr_def );

	/* {[[gݒ */
	h8s_sci_wrb( siopinib->reg_base, BRR, siopinib->boud_brr_def );

	/*
	 *  ݋֎~ƃNbN\[XI
	 *@@NbN\[X͓NbNI
	 */
	h8s_sci_and( siopinib, SCR, ~( TIE | RIE | MPIE | TEIE | CKE1 | CKE0 ) );

	/* {[[g̈艻(1bit̑҂) */
	sil_dly_nse_long( 1000000000ul / (siopinib->boud_rate) );

	/* G[tONA */
	h8s_sci_and( siopinib, SSR, ~( ORER | FER | PER ) );	/* C */

	/* MAM݋ */
	h8s_sci_or( siopinib, SCR, ( RIE | TE | RE ) );
}


/*
 *  SCI0̐ݒɖȂ`FbN
 */
#if defined(OMIT_SCI0) && (POL_PORTID == 1)
#error h8s_sci_putchar_pol serial port ID error.
#endif

/*
 *  J[lÑo[i[o͗p̏
 */
void
h8s_sci_init(void)
{
	h8s_sci_init_siopinib( get_siopinib(POL_PORTID) );
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
h8s_sci_openflag(void)
{
	BOOL ret;
#ifndef OMIT_SCI0
	ret = siopcb_table[0].openflag;
#else /* OMIT_SCI0 */
	ret = FALSE;
#endif /* OMIT_SCI0 */

#if TNUM_SIOP >= 2
	ret |= siopcb_table[1].openflag;
#endif /* TNUM_SIOP >= 2 */

#if TNUM_SIOP >= 3
	ret |= siopcb_table[2].openflag;
#endif /* TNUM_SIOP >= 3 */

	return(ret);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
h8s_sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB 		*siopcb = get_siopcb(siopid);
	const SIOPINIB  *siopinib = siopcb->siopinib;

	/* SCIWX^̏ */
	h8s_sci_init_siopinib( siopinib );

	/* ݃xݒAݗvNÁAsio_opn_por ōsB */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
h8s_sci_cls_por(SIOPCB *siopcb)
{
	/* TEND  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopcb->siopinib->reg_base, SSR ) & TEND ) );

	h8s_sci_and( siopcb->siopinib, SCR, ~( TE | RE ) );	/* C */
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
h8s_sci_snd_chr(SIOPCB *siopcb, char c)
{
	if( h8s_sci_putready(siopcb) ) {
		h8s_sci_putchar(siopcb, c);
		siopcb->putready = FALSE;
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
h8s_sci_rcv_chr(SIOPCB *siopcb)
{
	if( h8s_sci_getready(siopcb) ) {
		siopcb->getready = FALSE;
		return( (INT)(UB) h8s_sci_getchar(siopcb) );
			/* UB ̃LXǵAgh~邽 */
	}

	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		h8s_sci_or( siopcb->siopinib, SCR, TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_or( siopcb->siopinib, SCR, RIE );
		return;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch( cbrtn ) {
	case SIO_ERDY_SND:
		h8s_sci_and( siopcb->siopinib, SCR, ~TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_and( siopcb->siopinib, SCR, ~RIE );
		return;
	}
}

/*
 *  SIO̊݃T[rX[`
 *@@S`lʕCC֐ƂĒ`Ă
 */
Inline void
h8s_scix_isr_in(ID portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	/* MʒmR[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

Inline void
h8s_scix_isr_out(ID portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	/* M\R[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIO̎MG[݃T[rX[`
 *@@S`lʕCC֐ƂĒ`Ă
 *
 *  G[́ALG[tÕNÂ݁B
 *  EI[o[G[At[~OG[ApeBG[
 */
Inline void
h8s_scix_isr_error(INT portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	if( siopcb->openflag ) {
		/*  G[tONA  */
		h8s_sci_and( siopcb->siopinib, SSR, ~( RDRF | ORER | FER | PER ) );
	}
}


#ifndef OMIT_SCI0
/*
 *  SIO̊݃T[rX[` (SCI0p)
 */
void
h8s_sci0_isr_in(void)
{
	h8s_scix_isr_in(1);
}

void
h8s_sci0_isr_out(void)
{
	h8s_scix_isr_out(1);
}

/*
 *  SIO̎MG[݃T[rX[` (SCI0p)
 */
void
h8s_sci0_isr_error(void)
{
	h8s_scix_isr_error(1);
}

#endif /*  OMIT_SCI0  */

#if TNUM_SIOP >=2
/*
 *  SIO̊݃T[rX[` (SCI1p)
 */
void
h8s_sci1_isr_in(void)
{
	h8s_scix_isr_in(2);
}

void
h8s_sci1_isr_out(void)
{
	h8s_scix_isr_out(2);
}

/*
 *  SIO̎MG[݃T[rX[` (SCI1p)
 */
void
h8s_sci1_isr_error(void)
{
	h8s_scix_isr_error(2);
}
#endif /* TNUM_SIOP >=2 */

#if TNUM_SIOP >=3
/*
 *  SIO̊݃T[rX[` (SCI2p)
 */
void
h8s_sci2_isr_in(void)
{
	h8s_scix_isr_in(3);
}

void
h8s_sci2_isr_out(void)
{
	h8s_scix_isr_out(3);
}

/*
 *  SIO̎MG[݃T[rX[` (SCI2p)
 */
void
h8s_sci2_isr_error(void)
{
	h8s_scix_isr_error(3);
}
#endif /* TNUM_SIOP >=3 */


/*
 *  H8S  SCI p|[Oo (POL_PORTIDpAsys_putcŗp)
 */
void
h8s_sci_putchar_pol( char c )
{

	const SIOPINIB  *siopinib = get_siopinib( POL_PORTID );

	/* TDRE  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopinib->reg_base, SSR ) & TDRE ) );

	h8s_sci_wrb( siopinib->reg_base, TDR, c );

	/* TDRENA */
	h8s_sci_and( siopinib, SSR, ~TDRE );

	/* TEND  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopinib->reg_base, SSR ) & TEND ) );
}
