/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/* LɂėpĂAMAX_IPM  cpu_config.h Œ` */

#ifndef _MACRO_ONLY

/*
 *  䃌WX^̑֐
 */

#include <machine.h>	/*  n̑gݍ݊֐  */

/*
 *  RfVR[hWX^iCCRǰݒl̓Ǐo
 *@@UB current_ccr(void);
 *@@@@unsigned char get_ccr(void);
 */
#define current_ccr	get_ccr

/*
 *  RfVR[hWX^iCCRǰݒl̕ύX
 *@@gݍ݊֐set_ccr()̂܂܎gB
 *@@void set_ccr(unsigned char ccr);
 */

/*
 *  GNXehWX^iEXRǰݒl̓Ǐo
 *@@UB current_exr(void);
 *@@@@unsigned char get_exr(void);
 */
#define current_exr	get_exr

/*
 *  GNXehWX^iEXRǰݒl̕ύX
 *@@gݍ݊֐set_exr()̂܂܎gB
 *@@void set_exr(unsigned char exr);
 */

/*
 *  ݃}XN색Cu (݃[hQp)
 */

/*
 *  ݃}XŇݒl̓Ǐo
 *@@IPM current_intmask(void);
 *@@@@unsigned char get_imask_exr(void);
 */
#define current_intmask		(IPM)get_imask_exr

/*
 *  ݃}XN̐ݒ
 *@@@Eintmask͈̔̓`FbN͏ȗĂB
 */
#define set_intmask(intmask)	set_imask_exr(intmask)

/* p`
 *@@J[lǗ̊  ݃xMAX_IPM ȉ̊
 *@@J[lǗO̊  vCIeBx(MAX_IPM+1)
 *@@@@@@@@@@@@@@@ȏ݂̊NMI
 */

/*
 *  J[lǗ݂̊֎~
 *@@@EEXRWX^̃g[XrbgT̕ۑ͏ȗĂB
 */
#define disint()	set_intmask( (UB)MAX_IPM )

/*
 *  J[lǗ݂̊
 *@@@EEXRWX^̃g[XrbgT̕ۑ͏ȗĂB
 *@@@Ȅ́AAJ[lǗ̗L킸A
 *@@@@ׂĂ݂̊邱ƂɂȂĂB
 */
#define enaint()	set_intmask( (UB)0 )

/*
 *  ݃bNԂ̐p֐
 */

/*
 *  J[lǗO܂߂ĂׂĂ݂̊֎~ (NMI)
 *@@@EEXRWX^̃g[XrbgT̕ۑ͏ȗĂB
 */
#define _disint_()	set_exr( EXR_I_MASK )


#endif /* _MACRO_ONLY */

#endif /* _CPU_INSN_H_ */
