/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Kunihiko Ohnaka
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */

#include <sys_rename.h>

/*
 *  ^[QbgVXẽn[hEFA̒`
 */

#include <h8_3069f.h>

/*
 *  NbZ[W̃^[Qbg
 */

#define	TARGET_NAME	"NKEV-010H8"

/*
 *  chg_ipmT|[g邩ǂ̒`
 */
#define SUPPORT_CHG_IPM

/*
 *  vxget_tim T|[g邩ǂ̒`
 */

#define	SUPPORT_VXGET_TIM

/*
 *   X^bN̈̒`
 */

#define STACKTOP    	(H8IN_RAM_BASE + H8IN_RAM_SIZE)	/* ^XNƗpX^bN̏l */
#define str_STACKTOP	_TO_STRING(STACKTOP)

#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */

extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^ďoŎ邱Ƃz肵
 *  ĂD
 */

extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^ďoŎ邱
 *  Ƃz肵ĂD
 */

extern void cpu_putc(char c);

Inline void
sys_putc(char c)
{
#ifndef GDB_STUB

	cpu_putc(c);

#else	/* of #ifndef GDB_STUB */

/* GDB STUBgꍇɒ჌xo͂GDB̃R\[֏o */
	asm ("	push.l	er1			\n"\
		"	mov.l	er0, er1	\n"\
		"	sub.l	er0, er0	\n"\
		"	trapa	#1			\n"\
		"	pop.l	er1			\n"\
	);

#endif	/* of #ifndef GDB_STUB */

	};

#endif /* _MACRO_ONLY */


/*
 *  (1) VA|[g̐ݒ
 *  (2) ^C}[̐ݒ
 *  (3) OAhXԐ
 */

/*
 *  T|[gVAfBoCX͍̐ő 3B
 *  A݂ 2 ܂Œ`ĂB
 *  
 *  TvvO𓮂ꍇ
 *  sys_defs.hɂTASK_PORTID̒`ɂ
 */

#ifdef GDB_STUB

/* GDB stubgpƂ͋ITNUM_POTR = 1ɂ */
#define TNUM_PORT	1

#else	/* of #ifdef GDB_STUB */

#define TNUM_PORT	2

#endif	/* of #ifdef GDB_STUB */

#define	CONSOLE_PORTID		SYSTEM_PORTID	/* R\[ɗpVA|[gԍ     */
#define	LOGTASK_PORTID		SYSTEM_PORTID	/* VXeOo͂VA|[gԍ */

#define H8_MIN_BAUD_RATE	9600		/* SCI N[YȎ҂Ԃ̌vZɎgpB*/

/* G[荞݂A͊荞݂ƕʂɑ삷ꍇ̓Rg͂B*/
/*#define H8_CFG_SCI_ERR_HANDLER*/

/*
 *  SYSTEM p SCI ̐ݒl
 */

#ifdef GDB_STUB

/* GDB stubgp鎞SYSTEM_SCISCI0gp */
#define SYSTEM_SCI			H8SCI0
#define SYSTEM_SCI_IPR		H8IPRB
#define SYSTEM_SCI_IP_BIT	H8IPR_SCI0_BIT

#else	/* of #ifdef GDB_STUB */

#define SYSTEM_SCI			H8SCI1
#define SYSTEM_SCI_IPR		H8IPRB
#define SYSTEM_SCI_IP_BIT	H8IPR_SCI1_BIT

#endif	/* of #ifdef GDB_STUB */

#define SYSTEM_SCI_SMR		0
			/* MtH[}bg			*/
	     		/* 				*/
	     		/* LN^OXF8rbg		*/
	     		/* peBȂ				*/
	     		/* XgbvrbgOXF1		*/
	     		/* NbNZNgij:1		*/

#define SYSTEM_BAUD_RATE	38400			/* bps	*/

#if TNUM_PORT == 1

#define	SYSTEM_PORTID		1

#ifdef GDB_STUB

#define INHNO_SERIAL_IN		IRQ_RXI0
#define INHNO_SERIAL_OUT	IRQ_TXI0
#define INHNO_SERIAL_ERR	IRQ_ERI0

#else	/*	#ifdef GDB_STUB */

#define INHNO_SERIAL_IN		IRQ_RXI1
#define INHNO_SERIAL_OUT	IRQ_TXI1
#define INHNO_SERIAL_ERR	IRQ_ERI1

#endif	/*	#ifdef GDB_STUB */

#elif TNUM_PORT == 2	/* of #if TNUM_PORT == 1 */

#define USER_SCI		H8SCI0

#define USER_SCI_IPR		H8IPRB
#define USER_SCI_IP_BIT		H8IPR_SCI0_BIT

#define USER_SCI_SMR		0
			/* MtH[}bg			*/
	     		/* 				*/
	     		/* LN^OXF8rbg		*/
	     		/* peBȂ				*/
	     		/* XgbvrbgOXF1		*/
	     		/* NbNZNgij:1		*/

#define USER_BAUD_RATE		38400			/* bps	*/

#define	USER_PORTID		1
#define	SYSTEM_PORTID		2

#define INHNO_SERIAL_IN		IRQ_RXI0
#define INHNO_SERIAL_OUT	IRQ_TXI0
#define INHNO_SERIAL_ERR	IRQ_ERI0

#define INHNO_SERIAL2_IN	IRQ_RXI1
#define INHNO_SERIAL2_OUT	IRQ_TXI1
#define INHNO_SERIAL2_ERR	IRQ_ERI1

#else	/* of #if TNUM_PORT == 1 */

#error TNUM_PORT <= 2

#endif	/* of #if TNUM_PORT == 1 */

/*  vCIeBxݒp̃f[^  */

/*  ݗṽxݒ  */
#define SYSTEM_SCI_IPM			IPM_LEVEL0
#define USER_SCI_IPM			IPM_LEVEL0

/*  
 * ݃nhs̊݃}XN̒l
 * @@݂̊}XN邽߂̐ݒ  
 * @@Ɠx̊ݗvubN邽߁A
 * @@L̊ݗvxPxɐݒ肷B
 */
#if TNUM_PORT == 1	/*  |[gPFVXeE|[g  */

/*  VXeE|[g  */
#if SYSTEM_SCI_IPM == IPM_LEVEL0
#define sio_in_handler_intmask		IPM_LEVEL1
#elif SYSTEM_SCI_IPM == IPM_LEVEL1
#define sio_in_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_SCI_IPM == IPM_LEVEL0 */


#elif TNUM_PORT == 2	/* of #if TNUM_PORT == 1 */
			/*  |[gPF[U[E|[g  */
			/*  |[gQFVXeE|[g  */
/*  [U[E|[g  */
#if USER_SCI_IPM == IPM_LEVEL0
#define sio_in_handler_intmask		IPM_LEVEL1
#elif USER_SCI_IPM == IPM_LEVEL1
#define sio_in_handler_intmask		IPM_LEVEL2
#endif 	/* USER_SCI_IPM == IPM_LEVEL0 */

/*  VXeE|[g  */
#if SYSTEM_SCI_IPM == IPM_LEVEL0
#define sio_in2_handler_intmask		IPM_LEVEL1
#elif SYSTEM_SCI_IPM == IPM_LEVEL1
#define sio_in2_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_SCI_IPM == IPM_LEVEL0 */

#endif	/* of #if TNUM_PORT == 1 */

#define sio_out_handler_intmask		sio_in_handler_intmask
#define sio_err_handler_intmask		sio_in_handler_intmask

#ifndef GDB_STUB

#define sio_out2_handler_intmask	sio_in2_handler_intmask
#define sio_err2_handler_intmask	sio_in2_handler_intmask

#endif
/*
 *  ^C}̐ݒ
 */

#define SYSTEM_TIMER		H816TU0

#define SYSTEM_TIMER_CNT	(SYSTEM_TIMER + H8TCNT)
#define SYSTEM_TIMER_TCR	(SYSTEM_TIMER + H8TCR)
#define SYSTEM_TIMER_TIOR	(SYSTEM_TIMER + H8TIOR)
#define SYSTEM_TIMER_IER	H816TU_TISRA
#define SYSTEM_TIMER_IFR	H816TU_TISRA
#define SYSTEM_TIMER_TSTR	H816TU_TSTR
#define SYSTEM_TIMER_GR		(SYSTEM_TIMER + H8GRA)

#define SYSTEM_TIMER_STR	H8TSTR_STR0
#define SYSTEM_TIMER_STR_BIT	H8TSTR_STR0_BIT
#define SYSTEM_TIMER_IE		H8TISRA_IMIEA0		/* interrupt mask */
#define SYSTEM_TIMER_IE_BIT	H8TISRA_IMIEA0_BIT
#define SYSTEM_TIMER_IF		H8TISRA_IMFA0		/* match flag */
#define SYSTEM_TIMER_IF_BIT	H8TISRA_IMFA0_BIT

#define INHNO_TIMER		IRQ_IMIA0

#define SYSTEM_TIMER_TCR_BIT	(H8TCR_CCLR0 | H8TCR_TPSC1 | H8TCR_TPSC0)
#define SYSTEM_TIMER_TIOR_BIT	(0)

#define TIMER_CLOCK		((CPU_CLOCK)/8000)	/* 20MHz / 8 = 2.5MHz = 2500KHz */

/*  vCIeBxݒp̃f[^  */

/*  ݗṽxݒ  */
#define SYSTEM_TIMER_IPR                H8IPRA
#define SYSTEM_TIMER_IP_BIT             H8IPR_ITU0_BIT
#define SYSTEM_TIMER_IPM                IPM_LEVEL1

/*  
 * ݃nhs̊݃}XN̒l
 * @@݂̊}XN邽߂̐ݒ  
 * @@Ɠx̊ݗvubN邽߁A
 * @@L̊ݗvxPxɐݒ肷B
 */
#if SYSTEM_TIMER_IPM == IPM_LEVEL0
#define timer_handler_intmask		IPM_LEVEL1
#elif SYSTEM_TIMER_IPM == IPM_LEVEL1
#define timer_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_TIMER_IPM == IPM_LEVEL0 */

/*
 *  OAhXԐ
 */

#define	ENABLE_P8_CS		(H8P8DDR_CS0|H8P8DDR_CS1|H8P8DDR_CS2|H8P8DDR_CS3)

#if 0

#define	ENABLE_LOWER_DATA
#define	ENABLE_PB_CS		(H8PADDR_CS4|H8PADDR_CS5|H8PADDR_CS6|H8PBDDR_CS7)

#endif	/* of #if 0 */

#define	HEAP_TOP		0x600000UL

/*
 *  ԑ҂̂߂̒`
 */

#if defined(ROM)

/*  ROMi߂tbVROMɔzuĂj  */
#define	SIL_DLY_TIM1	 4540
#define	SIL_DLY_TIM2	  529

#elif defined(INMEM_ONLY)

/*  ROMÂݎgp */
#define	SIL_DLY_TIM1	 2800
#define	SIL_DLY_TIM2	  521

#else	/* of #if defined(ROM) */

/*  ߂ORAMɔzuĂ  */
#define	SIL_DLY_TIM1	 8290
#define	SIL_DLY_TIM2	 1693

#endif	/* of #if defined(ROM) */


/*
 *  DDȐl̒`
 */

#define	H8P1DDR0        0xff				/*  |[g1  */
#define	H8P2DDR0        0xff				/*  |[g2  */
#define	H8P3DDR0        DUMMY				/*  |[g3  */
#define	H8P4DDR0        DUMMY				/*  |[g4  */
#define	H8P5DDR0        0xff				/*  |[g5  */
#define	H8P6DDR0        DUMMY				/*  |[g6  */

/*  |[g7͓͐pDDRWX^Ȃ߁AȗĂB  */

#define	H8P8DDR0        (H8P8DDR_CS1 | H8P8DDR_CS2 | H8P8DDR_CS3)
							/*  |[g8  */
#define	H8P9DDR0        DUMMY				/*  |[g9  */
#define	H8PADDR0        DUMMY				/*  |[gA  */
#define	H8PBDDR0        DUMMY				/*  |[gB  */

#endif /* _SYS_CONFIG_H_ */
