/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: hw_serial.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  ^[QbgˑVAI/OW[iH8pj
 *    E|[g 1{̏ꍇ HWPORT1_ADDRɎw肳ꂽ|[ggpA
 *      2{̏ꍇ́AHWPORT1_ADDR[UpAHWPORT2_ADDRR\[
 *      o͂ƂĎgpB
 *      HWPORTx_ADDR ^[Qbgˑ sys_config.hŎw肷B
 *    Eʕ̃W[ɂāAXON/XOFFt[䂪s
 *      Ă̂ŁAMTxDRxD2{ł悢
 */

#include "jsp_kernel.h"
#include <hw_serial.h>
#include <h8_sil.h>

/*
 *  {[[g1rbg̎[nsec]ɕϊ}N
 *  @Z̓rŃI[o[t[Ȃ悤long^萔pĂ
 */
#define BAUD_TO_NSEC(b)       (UINT)(((1000000ul / (b)) + 1ul) * 1000ul)

/*
 *  {[[gBRR̒lɕϊ}N
 */
#define H8BRR_RATE(b)	(((b)>38400)?((UB)(((CPU_CLOCK+(16*(b)))/(32*(b)))-1))\
			          :((UB)((CPU_CLOCK/(32*(b)))-1)))

/*
 *  VA|[g̏ubN
 */

static const SIOPINIB siopinib_table[TNUM_PORT] = {
	{
		SYSTEM_SCI,
		SYSTEM_BAUD_RATE,
                {
                        (UB*)SYSTEM_SCI_IPR,
                        SYSTEM_SCI_IP_BIT,
                        SYSTEM_SCI_IPM
                },
		SYSTEM_SCI_SMR
	}

#if TNUM_PORT >= 2
	,{
		USER_SCI,
		USER_BAUD_RATE,
                {
                        (UB*)USER_SCI_IPR,
                        USER_SCI_IP_BIT,
                        USER_SCI_IPM
                },
		USER_SCI_SMR
	}
#endif	/* of #if TNUM_PORT >= 2 */

#if TNUM_PORT >= 3
	,{
		USER2_SCI,
		USER2_BAUD_RATE,
                {
                        (UB*)USER2_SCI_IPR,
                        USER2_SCI_IP_BIT,
                        USER2_SCI_IPM
                },
		USER2_SCI_SMR
	}
#endif	/* of #if TNUM_PORT >= 3 */

};


/*
 *  VA|[g̐ubN
 */

SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ǗubNւ̕ϊ}N
 */

#define get_siopinib(sioid)	(&(siopinib_table[INDEX_SIO(sioid)]))

/*
 *  SCI ̏
 */

void
SCI_initialize (ID sioid)
{
	const SIOPINIB	*inib;

	inib = get_siopinib(sioid);
	SCI_cls_por(inib->base);
			/*
			 *@[hݒ
			 *@@E
			 *@@ELN^
			 *@@EpeB
			 *@@EXgbvrbg
			 *@@ENbNI
			 */
	sil_wrb_mem((VP)(inib->base + H8SMR), inib->smr_init);

					/*  {[[gݒ  	*/
	sil_wrb_mem((VP)(inib->base + H8BRR), H8BRR_RATE(inib->baudrate));

			/* ݋֎~ƃNbN\[X̑I	*/
	h8_anb_reg((UB *)(inib->base + H8SCR),
            	    (UB)~(H8SCR_TIE  | H8SCR_RIE  | H8SCR_MPIE |
            	          H8SCR_TEIE | H8SCR_CKE1 | H8SCR_CKE0 ));

	/* {[[g̐ݒA1rbg҂Ȃ΂ȂȂB*/
	sil_dly_nse(BAUD_TO_NSEC(inib->baudrate));

					/* G[tONA		*/
	h8_anb_reg((UB *)(inib->base + H8SSR),
	            ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        /*
         *  vCIeBx̐ݒ
         *      {͊݃Rg[ˑ𕪗ׂ
         */
        define_int_plevel(&(inib->irc));

	/* M荞݂ƑM݂̋̓VA I/O ōs */
	/* M */
	h8_orb_reg((VP)(inib->base + H8SCR), (H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI ̃N[Y
 */

void
SCI_cls_por (UW base)
{
	/* TDRE  1 ɂȂ܂ő҂ */
	while ((sil_reb_mem((VP)(base + H8SSR)) & H8SSR_TDRE) == 0)
		;

	/* 11rbgM҂B*/
	sil_dly_nse(11*BAUD_TO_NSEC(H8_MIN_BAUD_RATE));
					/* M~		*/
	h8_anb_reg((UB *)(base + H8SCR),
	           (UB)~(H8SCR_TIE | H8SCR_RIE | H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI_in_handler -- SCI ͊݃nh
 */

void
SCI_in_handler(ID sioid)
{
	SIOPCB	*pcb;
	UB	status;
	
	pcb = get_siopcb(sioid);
	status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
	
	if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

		/* G[		*/

	    	/* G[tONA	*/
		sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
		            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
	}

	if (status & H8SSR_RDRF) {
		if (pcb->openflag) {
			/* M\R[obN[`ďoB*/
			SCI_ierdy_rcv(pcb->exinf);
		} else {
			sil_wrb_mem((VP)(pcb->inib->base + H8SSR), 
			             status & ~H8SSR_RDRF);
		}
	}
}

/*
 *  SCI_out_handler -- SCI o͊݃nh
 */

void
SCI_out_handler(ID sioid)
{
	SIOPCB	*pcb;

	pcb = get_siopcb(sioid);
	if (pcb->openflag) {
		/* M\R[obN[`ďoB*/
		SCI_ierdy_snd(pcb->exinf);
	}
}

#ifdef H8_CFG_SCI_ERR_HANDLER

/*
 *  SCI_err_handler -- SCI G[͊݃nh
 */

void
SCI_err_handler(ID sioid)
{
	SIOPCB	*pcb;
	UB	status;

	pcb = get_siopcb(sioid);
	status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
	if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

		/* G[		*/

	    	/* G[tONA	*/
		sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
		            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
	}
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

/*
 *  sio_initialize -- VA|[ghCȍ
 */

void
sio_initialize (void)
{
	int ix;

	/* SIO ǗubN̏ */
	for (ix = TNUM_PORT; ix -- > 0; ) {
		siopcb_table[ix].inib     = &siopinib_table[ix];
		siopcb_table[ix].openflag = FALSE;
	}
}

/*
 *  sio_ena_cbr -- VA I/O ̃R[obN̋
 */

void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		SCI_enable_send(pcb);
		break;
	case SIO_ERDY_RCV:
		SCI_enable_recv(pcb);
		break;
	}
}

/*
 *  sio_dis_cbr -- VA I/O ̃R[obN̋֎~
 */

void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		SCI_disable_send(pcb);
		break;
	case SIO_ERDY_RCV:
		SCI_disable_recv(pcb);
		break;
	}
}

/*
 *  SCI 荞
 */

void
sio_in_handler (void)
{
	SCI_in_handler(1);
}

void
sio_out_handler (void)
{
	SCI_out_handler(1);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err_handler (void)
{
	SCI_err_handler(1);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2

void
sio_in2_handler (void)
{
	SCI_in_handler(2);
}

void
sio_out2_handler (void)
{
	SCI_out_handler(2);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err2_handler (void)
{
	SCI_err_handler(2);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */
#endif	/* of #if TNUM_PORT >= 2 */

#if TNUM_PORT >= 3

void
sio_in3_handler (void)
{
	SCI_in_handler(3);
}

void
sio_out3_handler (void)
{
	SCI_out_handler(3);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err3_handler (void)
{
	SCI_err_handler(3);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif	/* of #if TNUM_PORT >= 3 */

