/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: hw_serial.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  ^[QbgˑVAI/OW[iH8pj
 *    E|[g 1{̏ꍇ HWPORT1_ADDRɎw肳ꂽ|[ggpA
 *      2{̏ꍇ́AHWPORT1_ADDR[UpAHWPORT2_ADDRR\[
 *      o͂ƂĎgpB
 *      HWPORTx_ADDR ^[Qbgˑ sys_config.hŎw肷B
 *    Eʕ̃W[ɂāAXON/XOFFt[䂪s
 *      Ă̂ŁAMTxDRxD2{ł悢
 */

#include "jsp_kernel.h"
#include <hw_serial.h>

/*
 *  VA|[g̏ubN
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = {
        {
                (UB*)SCI_PORT1_BASE,
                SCI_PORT1_BAUD_RATE,
                {
                        (UB*)SCI_PORT1_IPR,
                        SCI_PORT1_IPR_BIT,
                        SCI_PORT1_IPM
                },
                SCI_PORT1_SMR
        }

#if TNUM_PORT == 2u
        ,{
                (UB*)SCI_PORT2_BASE,
                SCI_PORT2_BAUD_RATE,
                {
                        (UB*)SCI_PORT2_IPR,
                        SCI_PORT2_IPR_BIT,
                        SCI_PORT2_IPM
                },
                SCI_PORT2_SMR
        }
#endif  /* of #if TNUM_PORT == 2u */

};


/*
 *  VA|[g̐ubN
 */
SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ǗubNւ̕ϊ
 */
Inline SIOPINIB*
get_siopinib(ID sioid)
{
	UINT index = INDEX_SIO(sioid);
	
	assert(index < TNUM_PORT);
	
    return(&(siopinib_table[index]));
}

/*
 *  {[[gBRRWX^̐ݒlւ̕ϊ
 *  @Z̓rŃI[o[t[Ȃ悤UW^pĂ
 */
Inline UB 
baud_to_brr(UW baud)
{
	UB brr;
	
	if (baud > 38400ul) {
		brr = (UB)(((CPU_CLOCK+(16ul*baud)) / (32ul*baud))-1ul);
	} else {
		brr = (UB)((CPU_CLOCK / (32ul*baud))-1ul);
	}
	return brr;
}

/*
 *  {[[gݒ̑҂[nsec]߂}N
 *  @Z̓rŃI[o[t[Ȃ悤UW^ɃLXgĂ
 */
#define SCI_SETUP_TIME(b)       (((1000000ul / (b)) + 1ul) * 1000ul)

/*
 *  SCI ̏
 */
void
SCI_initialize (ID sioid)
{
        const SIOPINIB  *inib = get_siopinib(sioid);
        
        assert(inib != (SIOPINIB*)NULL);
        SCI_cls_por(inib->base);

        sil_wrb_mem((VP)(inib->base + H8SMR), (VB)(inib->smr_init));

                                        /*  {[[gݒ      */
        sil_wrb_mem((VP)(inib->base + H8BRR), (VB)baud_to_brr(inib->baudrate));

                        /* ݋֎~ƃNbN\[X̑I     */
        h8_anb_reg(inib->base + H8SCR,
                     (UB)~(H8SCR_TIE  | H8SCR_RIE  | H8SCR_MPIE | H8SCR_TEIE |
                                                              H8SCR_CKE1 | H8SCR_CKE0 ));

        /* {[[g̐ݒA1rbg҂Ȃ΂ȂȂB*/
        sil_dly_nse_long(SCI_SETUP_TIME(inib->baudrate));

                                        /* G[tONA         */
        h8_anb_reg(inib->base + H8SSR, (UB)~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        /*
         *  vCIeBx̐ݒ
         *      {͊݃Rg[ˑ𕪗ׂ
         */
        define_int_plevel(&(inib->irc));

        /* M荞݂ƑM݂̋̓VA I/O ōs */
        /* M */

        h8_orb_reg(inib->base + H8SCR, (UB)(H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI ̃N[Y
 */
void
SCI_cls_por (UB *base)
{
	    UB ssr;
	    
        /* TDRE  1 ɂȂ܂ő҂ */
        do {
			ssr = sil_reb_mem((VP)(base + H8SSR));
			ssr &= H8SSR_TDRE;
        } while(ssr == 0u);

        /* 11rbgM҂B*/
        /*
         * vF1.2msec肷̂ŁȀCPU
         * @@@@􂾂A^XNReLXg
         * @@@@Ă΂\̂ŁÂ܂܂ɂĂB
         */
        sil_dly_nse_long(SCI_SETUP_TIME(H8_MIN_BAUD_RATE)*11ul);

                                        /* M~           */
        h8_anb_reg(base + H8SCR,
                    (UB)(~(H8SCR_TIE | H8SCR_RIE | H8SCR_TE | H8SCR_RE)));
}

/*
 *  SCI_in_handler -- SCI ͊݃nh
 */
void
SCI_in_handler(ID sioid)
{
        SIOPCB  *pcb = get_siopcb(sioid);
        UB      status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
		UB      flag = (UB)(status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        if (flag != 0) {

                /* G[           */

                /* G[tONA */
                sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
                            (VB)(status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER)));
        }

		flag = (UB)(status & H8SSR_RDRF);
        if (flag != 0) {
                if (pcb->openflag == TRUE) {
                        /* M\R[obN[`ďoB*/
                        SCI_ierdy_rcv(pcb->exinf);
                } else {
                        sil_wrb_mem((VP)(pcb->inib->base + H8SSR), (VB)(status & ~H8SSR_RDRF));
                }
        }
}

/*
 *  SCI_out_handler -- SCI o͊݃nh
 */
void
SCI_out_handler(ID sioid)
{
        SIOPCB  *pcb;

        pcb = get_siopcb(sioid);
        if (pcb->openflag == TRUE) {
                /* M\R[obN[`ďoB*/
                SCI_ierdy_snd(pcb->exinf);
        }
}

#ifdef H8_CFG_SCI_ERR_HANDLER

/*
 *  SCI_err_handler -- SCI G[͊݃nh
 */
void
SCI_err_handler(ID sioid)
{
        SIOPCB  *pcb;
        UB      status;

        pcb = get_siopcb(sioid);
        status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
        if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

                /* G[           */

                /* G[tONA */
                sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
                            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
        }
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

/*
 *  sio_initialize -- VA|[ghCȍ
 */
void
sio_initialize(void)
{
        INT ix;

        /* SIO ǗubN̏ */
        for (ix = 0; ix < TNUM_PORT; ix++) {
                siopcb_table[ix].inib     = &siopinib_table[ix];
                siopcb_table[ix].openflag = FALSE;
        }
}

/*
 *  sio_ena_cbr -- VA I/O ̃R[obN̋
 */
void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
        switch (cbrtn) {
        case SIO_ERDY_SND:
                SCI_enable_send(pcb);
                break;
        case SIO_ERDY_RCV:
                SCI_enable_recv(pcb);
                break;
        default:
                assert(FALSE);
        }
}

/*
 *  sio_dis_cbr -- VA I/O ̃R[obN̋֎~
 */
void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
        switch (cbrtn) {
        case SIO_ERDY_SND:
                SCI_disable_send(pcb);
                break;
        case SIO_ERDY_RCV:
                SCI_disable_recv(pcb);
                break;
        default:
                assert(FALSE);
        }
}

/*
 *  SCI 荞
 */
void
sio_in_handler (void)
{
        SCI_in_handler(SCI_PORTID1);
}

void
sio_out_handler (void)
{
        SCI_out_handler(SCI_PORTID1);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err_handler (void)
{
        SCI_err_handler(SCI_PORTID1);
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2u

void
sio_in2_handler (void)
{
        SCI_in_handler(SCI_PORTID2);
}

void
sio_out2_handler (void)
{
        SCI_out_handler(SCI_PORTID2);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err2_handler (void)
{
        SCI_err_handler(SCI_PORTID2);
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif  /* of #if TNUM_PORT >= 2u */
