/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *      vZbTˑW[iH8pj
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include <h8.h>

/*
 *  J[l̓ʖ̃l[
 */

#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */

#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define TBIT_TCB_TSTAT          8       /* tstat tB[h̃rbg */
#define TBIT_TCB_PRIORITY       8       /* priority tB[h̃rbg */


#ifndef _MACRO_ONLY

/*
 *  ^XNReLXgubN̒`
 */

typedef struct task_context_block {
        VP      sp;             /* X^bN|C^ */
        FP      pc;             /* vOJE^ */
} CTXB;

/*
 *  ݃}XN색Cu
 */

/*
 *  ݂̊݃}XN̓Ǐo
 */
Inline UB
current_intmask(void)
{
        UB ccr = current_ccr();
        
        ccr &= (UB)CCR_DISINT_ALL;
        return(ccr);
}

/*
 *  ݃}XN̐ݒ
 */
Inline void
set_intmask(UB intmask)
{
        UB ccr = current_ccr();
        
        /*
         *@and_ccr(),or_ccr()pɃ[JϐccrɈxA
         *@闝R
         *
         *@Eunloc_cou()Ă΂̂ŁAintmask̒lf܂
         *@@݋ɂȂĂ͂ȂB
         *  ERpČx}邽߁ALXgĂB 
         */
        ccr = (UB)((ccr & CCR_ENAINT_ALL) | intmask);
        set_ccr(ccr);
}

/*
 *  ݃lXgJE^
 */

extern volatile UB       intnest;

/*
 *  ReLXgQ
 *
 *  ݃lXgJE^ǂݏoɊ݂ĂA߂
 *  ɂ̓ReLXgɖ߂Ă
 */
Inline BOOL
sense_context(void)
{
	BOOL ret;
	
	ret = (intnest != 0) ? TRUE : FALSE;
	return(ret);
}

/*
 *  CPUbNԂ̎Q
 */

/*
 *  CPUbNԂ\tO
 */
extern volatile BOOL     iscpulocked;

#define sense_lock()    iscpulocked
#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Achg_ipm T|[g邽߂̕ϐBchg_ipm T|[g
 *  Ȃꍇɂ́At_unlock_cpu  task_intmask  0 ɒuĂ悢B
 */

#ifdef SUPPORT_CHG_IPM
extern volatile UB       task_intmask;   /* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
        disint();
        iscpulocked = TRUE;
}

Inline void
t_unlock_cpu(void)
{
        iscpulocked = FALSE;
#ifdef SUPPORT_CHG_IPM
        /*
         *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽߁B
         *  ̓r task_intmask 邱Ƃ͂ȂB
         */
        set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
        enaint();               /* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern volatile UB       int_intmask;    /* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu(void)
{
        UB      intmask = current_intmask();
        /*
         *  ꎞϐ intmask gĂ̂́Ccurrent_intmask()Ă
         *  Ɋ݂CNꂽ݃nh
         *  int_intmask ύX\邽߂łD
         */

        disint();
        int_intmask = intmask;
        iscpulocked = TRUE;
}

Inline void
i_unlock_cpu(void)
{
        iscpulocked = FALSE;
        set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */

extern void     dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */

extern void     exit_and_dispatch(void);

/*
 *
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 *
 *@H8łł͉Ȃ
 *@ixN^e[u}jAŕҏWj
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPUOnh̐ݒ
 *@@H8łł͎gpȂ
 */

Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  ݃nh̏o
 *@@H8CpH8ˑł݂͊̏oAZu\[X
 *@@邽߁A{CꒆŒ`KvȂB
 *@@ł͋ʕƂ̃C^[tF[X킹邽߁A
 *@@Kvȃ}N`݂̂ĂB
 */

/*
 *  Cꃋ[`̊֐̃x𐶐
 *@@H8CpH8ˑł͓vector.src̃[JEV{
 *@@ł̂ŁAO[oɌJKvȂB
 *@@ł͋ʕƂ̃C^[tF[X킹邽߁A
 *@@_~[̃x^ĂB
 */
#define INT_ENTRY(inthdr) _kernel_common_interrupt_process
#define EXC_ENTRY(exchdr) _kernel_common_interrupt_process

/*
 *  ݃nh̏o̐}N
 *@@@Cł͂܂łȂ߁AAZu\[X
 *@@@ʓrpӂB
 */
#define INTHDR_ENTRY(inthdr) extern void INT_ENTRY(inthdr)(void) throw()

/*
 *  CPUOnh̏o̐}N
 */
#define EXCHDR_ENTRY(exchdr) extern void EXC_ENTRY(exchdr)(void) throw()

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
        /* H8łł͌Ă΂ȂB */
        return(TRUE);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
        /* H8łł͌Ă΂ȂB */
        return(TRUE);
}

/*
 *  vZbTˑ̏
 */

extern void     cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */

extern void     cpu_terminate(void);

/*
 *  `ݔ̃G[õ͎X^bN\̒`
 */

typedef struct exc_stack {
	UW	er0;
	UW	er1;
	UW	er2;
	UW	er3;
	UW	er4;
	UW	er5;
	UW	er6;
	UW	pc;	/*  vOEJE^  	*/
} EXCSTACK;

/*
 * `ݔ̃G[o (cpu_config.c, cpu_support.S)
 */

extern void     cpu_experr(EXCSTACK *sp);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`D
 */
extern void cpu_putc(char c);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
