/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_sysio.h,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */

#ifndef _HW_SYSIO_H_
#define _HW_SYSIO_H_


#include "integrator.h"

/*
 *  VAI/O|[g̏
 */
Inline void
hw_sysio_initialize()
{
    /*disable interrupt*/
    sil_wrw_mem((VP)UART0_CR,~UCR_UARTEN);
    /*baud rate 38400*/
    sil_wrw_mem((VP)UART0_LCRM,ULCRM_38400);
    sil_wrw_mem((VP)UART0_LCRL,ULCRL_38400);
    /*8bits, 1Stop bit, no parity*/
    sil_wrw_mem((VP)UART0_LCRH,ULCRH_WLEN_8BIT);
    /*Clear all registers*/
    sil_wrw_mem((VP)UART0_ICR,0xff);
    /*enable interrupt*/
    sil_wrw_mem((VP)UART0_CR,UCR_UARTEN | UCR_RIE);
}


/*
 *  VAI/O|[g̏I
 */
Inline void
hw_sysio_terminate()
{
    /*disable interrupt*/
    sil_wrw_mem((VP)UART0_CR,~UCR_UARTEN);
}


/*
 *  𑗐Mł邩H
 */
Inline BOOL
hw_sysio_putready()
{
    return((sil_rew_mem((VP)UART0_FR) & UFR_BUSY)==0);
}


/*
 *  M镶̏
 */
Inline void
hw_sysio_putchar(UB c)
{
    while(!hw_sysio_putready())
        ;
    sil_wrw_mem((VP)UART0_DR,c);
}

#endif /* _HW_SYSIO_H_ */
