/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *    vZbTˑW[iARM4vTpj
 *
 *  ̃CN[ht@ĆCt_config.ĥ݂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[lʖ̃l[
 */
#include "cpu_rename.h"

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define    TBIT_TCB_TSTAT       8    /* tstat tB[h̃rbg */
#define    TBIT_TCB_PRIORITY    8    /* priority tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
    VP    sp;        /* X^bN|C^ */
    FP    pc;        /* vOJE^ */
} CTXB;

/*
 * 荞݂̃lXg񐔂̃JEg
 */
extern UW interrupt_count;


/*
 *  VXeԎQ
 */
Inline UB
current_mode()
{
    return(current_sr() & CPSR_MODE_MASK);
}

Inline BOOL
sense_context()
{
    return(interrupt_count > 0);
}

Inline BOOL
sense_lock()
{
    return(current_sr() & CPSR_IRQ_BIT);
}

#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock


/*
 *  CPUbNƂ̉
 *
 */

#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu


Inline void
lock_cpu()
{
    disint();
}

Inline void
unlock_cpu()
{
    enaint();
}


/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void    dispatch(void);


/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void    exit_and_dispatch(void);


/*
 * OxN^ɏ܂ꂽWv߂QƂAhX
 */
extern UW * arm_vector_add[8];


/*
 * Oɉnh̋NԒn
 */
extern UW arm_handler_add[8];


/*
 *  CPUOnh̐ݒ
 */
extern void define_exc(EXCNO excno, FP exchdr);


Inline void
arm_install_handler(EXCNO excno, FP exchdr)
{
    *arm_vector_add[excno] = (UW)exchdr;
}


/*
 *  CPUOnh̏o
 */


/*
 *  CPUOnh̏o̐}N
 *
 */
#define __EXCHDR_ENTRY(exchdr, stacktop)    \
extern void exchdr##_entry(VP sp);          \
asm(".text                             \n"  \
#exchdr "_entry:                       \n"  \
"       ldr   sp,.int_stack_"#exchdr"  \n"  /* X^bN̐؂ւ        */\
"       sub   lr,lr,#4                 \n"  /* undefłł?    */\
"       stmfd sp!, {r0 - r2,lr}        \n"  /* ꎞIint_stackɑҔ   */ \
"       mrs   r0, spsr                 \n"  /* SVC[hɐ؂ւ邽 */ \
"       mov   r1, sp                   \n"  /* ۑ                  */ \
"       mov   r2,#0xd3                 \n"  /* CPSȐ            */ \
"       msr   cpsr,r2                  \n" \
"       ldr   r2,[r1,#0x0C]            \n"     /* load  PC            */\
"       stmfd sp!,{r2}                 \n"     /* Store PC            */\
"       stmfd sp!,{r3,ip,lr}           \n"     /* Store r3,ip,lr      */\
"       ldmfd r1!,{r2,ip,lr}           \n"     /* load  r0,r1,r2      */\
"       stmfd sp!,{r0,r2,ip,lr}        \n"     /* SPSR,Store r0,r1,r2 */\
"       ldr  r2, .interrupt_count_"#exchdr"\n" /* d荞݂  */\
"       ldr  r3, [r2]                  \n" \
"       add  r0,r3,#1                  \n" \
"       str  r0, [r2]                  \n" \
"       mov  r0,sp                     \n" /* Onhւ̈ */\
"       cmp  r3, #0x00                 \n" \
"       ldreq   sp,stack_"#exchdr"     \n" /* X^bN̕ύX       */\
"       stmeqfd sp!,{r0}               \n" /* ^XNX^bN̕ۑ */\
"       mov   r2,#0x13                 \n" /* 荞݋         */\
"       msr   cpsr,r2                  \n" \
"       bl    "#exchdr"                \n" /* nhĂяo     */\
"       mov   r2,#0xd3                 \n" /* 荞݋֎~         */\
"       msr   cpsr,r2                  \n" \
"       ldr   r2,.interrupt_count_"#exchdr" \n"/* 荞݉񐔂   */\
"       ldr   r1, [r2]                 \n"     /* fNg     */\
"       sub   r3,r1,#1                 \n"\
"       str   r3, [r2]                 \n"\
"       cmp   r3,#0x00                 \n" /* 荞݃lXg?    */\
"       bne   return_to_task_"#exchdr" \n" \
"       ldmfd sp!,{r0}                 \n" /* ^XNX^bN̕A */\
"       mov   sp, r0                   \n"\
"       ldr   r1, reqflg_"#exchdr"     \n" /* Check reqflg         */\
"       ldr   r0,[r1]                  \n"\
"       cmp   r0,#0                    \n"\
"       beq   return_to_task_"#exchdr" \n"\
"       mov   r0,#0                    \n"\
"       str   r0,[r1]                  \n" /* Clear reqflg   */\
"       b     _kernel_ret_exc          \n" /* ret_int      */\
"return_to_task_"#exchdr":             \n" \
"       ldmfd sp!,{r1}                 \n" /* CPSR̕A */\
"       msr   spsr, r1                 \n" /* 荞݋   */\
"       ldmfd sp!,{r0-r3,ip,lr,pc}^     \n"\
"       .align 4                       \n"\
".int_stack_"#exchdr":                 \n"\
"       .word _kernel_int_stack + 6 * 4       \n"\
"reqflg_"#exchdr":                     \n"\
"       .word     _kernel_reqflg       \n"\
"stack_"#exchdr":                      \n"\
"       .word   " #stacktop "         \n"\
".interrupt_count_"#exchdr":           \n"\
"       .word   _kernel_interrupt_count       \n")


#define _EXCHDR_ENTRY(exchdr, stacktop)    __EXCHDR_ENTRY(exchdr, stacktop)

#define EXCHDR_ENTRY(exchdr)    _EXCHDR_ENTRY(exchdr, STACKTOP)

#define EXC_ENTRY(exchdr) exchdr##_entry


/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃fBXpb`
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    return(interrupt_count > 1);    
}


/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
    return((*((UW *)p_excinf) & CPSR_IRQ_BIT) == CPSR_IRQ_BIT );
}


/*
 * `̗Oꍇ
 */
extern void undef_exception();
extern void swi_exception();
extern void prefetch_exception();
extern void data_abort_exception();
extern void irq_abort_exception();
extern void fiq_abort_exception();


/*
 *  vZbTˑ̏
 */
extern void    cpu_initialize(void);


/*
 *  vZbTˑ̏I
 */
extern void    cpu_terminate(void);


/*
 * CPU/݃nh̏oňꎞIɎgpX^bN
 */
#define INT_STACK_SIZE 6
extern UW int_stack[INT_STACK_SIZE];


#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
