/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: message.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

// $Header: /cvsroot/jsp4cm3/jsp/cfg/base/message.h,v 1.1 2008/06/17 00:04:36 suikan Exp $

#ifndef MESSAGE_H
#define MESSAGE_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B
#  pragma warning(disable:4786) //fobOŎʎq255ɐ؂̂Ă܂B
#endif

#include <string>
#include <sstream>
#include <stdarg.h>
#include <stdexcept>

//#include "base/testsuite.h"
#include "base/singleton.h"
#include "base/except.h"

    /*
     *   񐮌`wp[NX
     */
class Formatter
{
protected:
    std::string       templatestring;    //ev[g
    std::stringstream content;           //񐮌`Əςݕ\ꏊpXg[
    bool              accept;            //\ǂ

        //̈̑}ւƈړ
    void shift(void) throw();

        //ݒ̈ (null) Œu
    void shift_all(void) throw();

public:
        //ftHgRXgN^
    Formatter(void) throw();

        //RXgN^
    Formatter(std::string src) throw();

        //Rs[RXgN^
    Formatter(const Formatter & src) throw();

        //ev[g̐ݒ (g͏)
    void assign(std::string src) throw();

        //ẽNA
    void clear(void) throw();

        //Zq
    Formatter & operator =(const Formatter & src) throw();

        //̐ݒ
    template<class T>
    Formatter & operator << (const T & src) throw()
    {
        std::string::size_type pos;

            //\Ȃ
        if(accept) {
            pos = content.str().size();
            content << src;

                /* 󕶎łȂΎ̑}ꏊɈړ */
            if(pos != content.str().size())
                shift();
        }
        return *this;
    }

        //bZ[W̎o
    std::string str(void) throw();

        //Wo̓Xg[ւ̏o͗p operator << `
    friend inline std::ostream & operator << (std::ostream & out, Formatter msg) throw()
    {
        out << msg.content.str();
        return out;
    }

//    TESTSUITE_PROTOTYPE(main)
};

    /*
     *   bZ[Wo͗p2Ήs񐮌`wp[NX
     */
class Message : public Formatter
{
public:
    enum tagLanguage
    {
        ENGLISH  = 0,
        JAPANESE = 1,

        LAST_LANG,              //Ō̈ʒu
        NEUTRAL  = ENGLISH,     //W
    };

        /* o̓bZ[WꐧNX */
    class MessageControl
    {
    protected:
        int language;   //ǂ̌gp̂

    public:
            //RXgN^
        SINGLETON_CONSTRUCTOR(MessageControl) throw() : language(NEUTRAL) {};

            //ANZT
        inline void setLanguage(int _language) throw()  { language = _language; }
        inline int  getLanguage(void) const    throw()  { return language; }

        const char * select(const char * msg1, const char * msg2, va_list vl ) throw();
    };

protected:

        //hNXpRXgN^
    void _initialize(const char * src1, const char * src2, va_list vl) throw();

public:
        //ftHgRXgN^
    Message(void) throw();

        //RXgN^ (Pꌾ)
    Message(std::string src) throw();

        //RXgN^ ()
    Message(const char * src1, const char * src2, ... ) throw();

        //Rs[RXgN^
    Message(const Message & src) throw();

        //ev[g̐ݒ (g͏)
    void assign(std::string src) throw() { Formatter::assign(src); }
    void assign(const char * src1, const char * src2, ... ) throw();

        //I
    static void selectLanguage(enum tagLanguage lang = NEUTRAL) throw();
        
        //̎擾
    static enum tagLanguage getCurrentLanguage(void) throw()
    {   return static_cast<enum tagLanguage>(Singleton<MessageControl>::getInstance()->getLanguage());   }

    //TESTSUITE_PROTOTYPE(main)
};


    /*
     *   璷o͗p񐮌`wp[NX
     */
class VerboseMessage : public Message
{
public:
        //ʂ̏璷o͏NX
    class VerboseControl
    {
    public:
        bool           verbose;     //璷o͂sǂ
        std::ostream * out;         //o͐

            //RXgN^
        SINGLETON_CONSTRUCTOR(VerboseControl) throw() : verbose(false), out(0)
        {}

            //璷o͐
        template<class T>
        inline const VerboseControl & operator << (const T & src) const throw()
        {
            if(verbose && out != 0)
                (*out) << src;
            return *this;
        }

            //verboseANZT
        void setVerbose(bool _verbose) throw()
        {   verbose = _verbose;   }
        bool getVerbose(void) const throw()
        {   return verbose;   }

            //outANZT
        void setStream(std::ostream * _out) throw()
        {   out = _out;   }
        std::ostream * getStream(void) throw()
        {   return out;   }
    };

        //璷o̓Xg[ (Pȗ}~@\bp[NX)
    class VerboseStream
    {
    protected:
        std::ostream * out;

    public:
        VerboseStream(std::ostream * _out = 0) throw() : out(_out) {};

        template<class T>
        VerboseStream & operator << (const T & src) throw()
        {
            if(out != 0)
                (*out) << src;
            return *this;
        }
    };

protected:
        //ftHgRXgN^ (eXgp)
    VerboseMessage(void) throw();

public:

        //RXgN^
    VerboseMessage(const char * src) throw();
    VerboseMessage(const std::string & src) throw();
    VerboseMessage(const char * src1, const char * src2, ... ) throw();

        //fXgN^
    ~VerboseMessage(void) throw();

        //璷o͐ (ANZT)
    inline static void setVerbose(bool _verbose) throw()
    {   Singleton<VerboseControl>::getInstance()->setVerbose(_verbose);   }

        //璷o͐Xg[ݒ (ANZT)
    inline static void setStream(std::ostream * _stream) throw()
    {   Singleton<VerboseControl>::getInstance()->setStream(_stream);   }

        //璷o͐̏Ԏ擾
    inline static bool getVerbose(void) throw()
    {   return Singleton<VerboseControl>::getInstance()->getVerbose();   }

        //璷o͐Xg[̎擾 (ݒ肵̂Ɠ̂͏oĂȂ)
    inline static VerboseStream getStream(void) throw()
    {   return VerboseStream(getVerbose() ? Singleton<VerboseControl>::getInstance()->getStream() : 0);   }

    //TESTSUITE_PROTOTYPE(main)
};

    /*
     *   ObZ[Wp񐮌`wp[NX
     */
class ExceptionMessage : public Message
{
public:
        //O̊댯xx
    enum tagLevel {
        DEFAULT = 0,
        FATAL   = 1,
        WARNING = 2
    };

#ifdef EXCEPT_H
    class ExceptionMessageException : public Exception
    {
    friend class ExceptionMessage;
    protected:
        ExceptionMessageException(int _code, std::string _details) throw() : Exception("ExceptionMessage", _code, _details) {}
    };
#endif

protected:
    enum tagLevel level;

public:
        //RXgN^
    ExceptionMessage(const char * src) throw();
    ExceptionMessage(const std::string & src) throw();
    ExceptionMessage(const char * src1, const char * src2, ...) throw();

    ExceptionMessage(enum tagLevel level = DEFAULT) throw();
    ExceptionMessage(enum tagLevel level, const char * src) throw();
    ExceptionMessage(enum tagLevel level, const std::string & src) throw();
    ExceptionMessage(enum tagLevel level, const char * src1, const char * src2, ...) throw();

    ExceptionMessage(const ExceptionMessage & src) throw();


        //댯xxQ
    inline bool operator == (enum tagLevel _level) const throw()
    {   return level == _level;   }

        //댯xxQ
    inline bool operator != (enum tagLevel _level) const throw()
    {   return !(operator ==(_level));   }

        //̐ݒ (ԋpľ^Message &  ExceptionMessage & ɂ邽߂̏׍H)
    template<class T>
    inline ExceptionMessage & operator << (const T & src) throw()
    {
        Message::operator << ( src );
        return *this;
    }

#ifdef EXCEPT_H     //ExceptionNXgpꍇ
        //O̔
    bool throwException(void) throw(Exception)
    {
        ExceptionMessageException exc(level, str());
        return exc.throwException();
    }
        //}js[^
    inline ExceptionMessage & operator << ( ExceptionMessage & (* func)(ExceptionMessage &) ) throw(Exception)
    {   return (*func)(*this);   }

#else               //stdexceptgpꍇ
        //O̔
    template<class T>
    bool throwException(void) throw(T)
    {
        throw T(str());
        return true;
    }
        //}js[^
    inline ExceptionMessage & operator << ( ExceptionMessage & (* func)(ExceptionMessage &) ) throw(T)
    {   return (*func)(*this);   }
#endif

    //TESTSUITE_PROTOTYPE(main)
};

#ifdef EXCEPT_H     //ExceptionNXgpꍇ

        //OX[邽߂̃}js[^
    inline ExceptionMessage & throwException(ExceptionMessage & excmsg) throw(Exception)
    {
        excmsg.throwException();
        return excmsg;
    }

#else
        //OX[邽߂̃}js[^
    template<class T>
    inline ExceptionMessage & throwException(ExceptionMessage & excmsg) throw(T)
    {
        excmsg.throwException<T>();
        return excmsg;
    }

#endif



    /*
     *   fobOo͗p񐮌`wp[NX
     */
class DebugMessage : public Formatter
{
public:
        //ʂ̏璷o͏NX (VOgɂ̂VerboseControl𓯂̂NX)
    class DebugControl : public VerboseMessage::VerboseControl
    { public: SINGLETON_CONSTRUCTOR_(DebugControl) throw() : VerboseMessage::VerboseControl(_singleton) {} };


protected:
        //ftHgRXgN^ (eXgp)
    DebugMessage(void) throw();

public:

        //RXgN^
    DebugMessage(std::string src) throw();

        //fXgN^
    ~DebugMessage(void) throw();

        //璷o͐ (ANZT)
    inline static void setVerbose(bool _verbose) throw()
    {   Singleton<DebugControl>::getInstance()->setVerbose(_verbose);   }

        //璷o͐Xg[ݒ (ANZT)
    inline static void setStream(std::ostream * _stream) throw()
    {   Singleton<DebugControl>::getInstance()->setStream(_stream);   }

        //璷o͐̏Ԏ擾
    inline static bool getVerbose(void) throw()
    {   return Singleton<DebugControl>::getInstance()->getVerbose();   }

        //璷o͐Xg[̎擾 (ݒ肵̂Ɠ̂͏oĂȂ)
    inline static VerboseMessage::VerboseStream getStream(void) throw()
    {   return VerboseMessage::VerboseStream(getVerbose() ? Singleton<DebugControl>::getInstance()->getStream() : 0);   }

//  TESTSUITE_PROTOTYPE(main)
};


#endif  //MESSAGE_H


