/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: message.cpp,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

// $Header: /cvsroot/jsp4cm3/jsp/cfg/base/message.cpp,v 1.1 2008/06/17 00:04:36 suikan Exp $

#include "base/message.h"

using namespace std;


/*****************************************************************************/

/*
 *   bZ[Wo͗p񐮌`wp[NX
 */

    //ftHgRXgN^
Formatter::Formatter(void) throw() : templatestring(""), accept(false)
{}

    //RXgN^
Formatter::Formatter(string src) throw() : templatestring(src)
{   shift();   }

    //Rs[RXgN^
Formatter::Formatter(const Formatter & src) throw() : templatestring(src.templatestring), accept(src.accept)
{
    string work;

    work = src.content.str();
    content << work;
}

    //̈̑}ւƈړ
void Formatter::shift(void) throw()
{
    string::size_type pos;

    accept = false;
    if(!templatestring.empty()) {

        do {
            pos = templatestring.find_first_of("%");

            if(pos != string::npos) {

                    /* %Ăꂪ\%Ƃ`ȂA%̂܂܏o */
                if(pos != string::npos && pos != 0 && templatestring.at(pos - 1) == '\\') {

                    if(pos > 1)
                        content << templatestring.substr(0, pos - 2);
                    content << '%';

                    templatestring = templatestring.substr(pos + 1);

                    continue;
                }
                else {
                        /* %܂ */
                    if(pos != string::npos)
                        accept = true;
                    break;
                }
            }
        } while(pos != string::npos);

        if(pos != string::npos) {
            if(pos != 0)
                content << templatestring.substr(0, pos);
            templatestring = templatestring.substr(pos + 1);
        }
        else {
            content << templatestring;
            templatestring.erase();
        }
    }
}


    //ݒ̈ (null) Œu
void Formatter::shift_all(void) throw()
{
    while(accept)
        *this << "(null)";
}

    //bZ[W̎o
string Formatter::str(void) throw()
{
    shift_all();
    return content.str();
}

    //ev[g̐ݒ (g͏)
void Formatter::assign(string src) throw()
{
    clear();
    templatestring.assign(src);
    shift();
}

    //ȅ
void Formatter::clear(void) throw()
{
    if(!templatestring.empty())
        templatestring.erase();
    content.str(string(""));
    accept = false;
}

    //Zq
Formatter & Formatter::operator =(const Formatter & src) throw()
{
    string work;

    templatestring = src.templatestring;
    accept         = src.accept;

    work = src.content.str();
    content << work;

    return *this;
}


/*****************************************************************************/

/*
 *   bZ[Wo͗p񐮌`wp[NX
 */

const char * Message::MessageControl::select(const char * msg1, const char * msg2, va_list vl) throw()
{
    const char * msg = msg1;
    int i = language;

    if(i > 0) {
        msg = msg2;

        while(--i > 0)
            msg = va_arg(vl, const char *);
    }

    return msg;
}

    //ftHgRXgN^ (eXgp)
Message::Message(void) throw()
{}

    //RXgN^
Message::Message(string src) throw() : Formatter(src)
{}

    //RXgN^ ()
Message::Message(const char * src1, const char * src2, ...) throw()
{
    va_list vl;

    va_start(vl, src2);
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

    //Rs[RXgN^
Message::Message(const Message & src) throw() : Formatter(src)
{}

    //hNX̏p֐ ()
void Message::_initialize(const char * src1, const char * src2, va_list vl) throw()
{
    content.clear();
    accept = false;
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

    //I
void Message::selectLanguage(enum tagLanguage lang) throw()
{
    if(lang >= 0 && lang < LAST_LANG)
        Singleton<Message::MessageControl>::getInstance()->setLanguage(lang);
}

    //ev[g̐ݒ (g͏)
void Message::assign(const char * src1, const char * src2, ... ) throw()
{
    va_list vl;

    clear();

    va_start(vl, src2);
    templatestring.assign(Singleton<MessageControl>::getInstance()->select(src1, src2, vl));
    shift();
}

/*****************************************************************************/

/*
 *   璷o͗p񐮌`wp[NX
 */

    //ftHgRXgN^
VerboseMessage::VerboseMessage(void) throw() : Message()
{}

    //RXgN^
VerboseMessage::VerboseMessage(const char * src) throw() : Message(src)
{}

    //RXgN^
VerboseMessage::VerboseMessage(const string & src) throw() : Message(src)
{}

    //RXgN^
VerboseMessage::VerboseMessage(const char * src1, const char * src2, ... ) throw() : Message()
{
    va_list vl;

    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //fXgN^
VerboseMessage::~VerboseMessage(void) throw()
{   Singleton< VerboseControl >::getInstance()->operator << (str());    }

/*****************************************************************************/

/*
 *   ObZ[Wp񐮌`wp[NX
 */

    //RXgN^
ExceptionMessage::ExceptionMessage(const char * src) throw() : Message(src), level(DEFAULT)
{}

    //RXgN^
ExceptionMessage::ExceptionMessage(const std::string & src) throw() : Message(src), level(DEFAULT)
{}

    //RXgN^
ExceptionMessage::ExceptionMessage(const char * src1, const char * src2, ...) throw() : Message(), level(DEFAULT)
{
    va_list vl;
    
    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //RXgN^
ExceptionMessage::ExceptionMessage(enum tagLevel _level) throw() : Message(), level(_level)
{}

    //RXgN^
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const char * src) throw() : Message(src), level(_level)
{}

    //RXgN^
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const std::string & src) throw() : Message(src), level(_level)
{}

    //RXgN^
ExceptionMessage::ExceptionMessage(enum tagLevel _level, const char * src1, const char * src2, ...) throw() : Message(), level(_level)
{
    va_list vl;
    
    va_start(vl, src2);
    _initialize(src1, src2, vl);
}

    //Rs[RXgN^
ExceptionMessage::ExceptionMessage(const ExceptionMessage & src) throw() : Message(src), level(src.level)
{}


/*****************************************************************************/

/*
 *   fobObZ[Wp񐮌`wp[NX
 */

    //RXgN^
DebugMessage::DebugMessage(string src) throw() : Formatter(src)
{}

    //fXgN^
DebugMessage::~DebugMessage(void) throw()
{   Singleton<DebugControl>::getInstance()->operator << (str());    }

