/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: event.cpp,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

// $Header: /cvsroot/jsp4cm3/jsp/cfg/base/event.cpp,v 1.1 2008/06/17 00:04:36 suikan Exp $

#include "base/event.h"

using namespace std;

/***************************** eXgXB[g *****************************/

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

namespace {
    class Event_fortest : public Event<int> 
    {   TESTSUITE_PROTOTYPE(main)   };

    int * ptr_i_dummy_handler;
    void dummy_handler(int & i)
    {
        ptr_i_dummy_handler = &i;
        ++ i;
        TestSuite::check("dummy_handler");
    }

    class EventHandler : public Event_fortest::Handler
    {
    public:
        int * ptr_i;

        EventHandler(void)  throw() { TestSuite::check("EventHandler::EventHandler");  }
        ~EventHandler(void) throw() { TestSuite::check("EventHandler::~EventHandler"); }
        void handler(Event_fortest::value_type & i) { ptr_i = &i; ++i; TestSuite::check("EventHandler::handler"); }
    };
}

TESTSUITE(main,Event_fortest)
{
    BEGIN_CASE("add","add") {
        BEGIN_CASE("1","addŃnho^ł") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);

            TEST_CASE("1","nhXg1Ă", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 1);
            TEST_CASE("2","nhXg̒g͐", *Singleton<Event_fortest::handler_list_type>::getInstance()->begin() == dummy_handler);
        } END_CASE;

        BEGIN_CASE("2","nh𕡐o^ł") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);

            TEST_CASE("1","nhXg̒g3", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 3);
            TEST_CASE("2","nhXg̒g͐", *Singleton<Event_fortest::handler_list_type>::getInstance()->begin() == dummy_handler);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("remove","remove") {
        BEGIN_CASE("1","addœo^nh폜ł") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::remove(dummy_handler);

            TEST_CASE("1","nhXg̗vf0", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 0);
        } END_CASE;

        BEGIN_CASE("2","o^SẴnh") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::remove(dummy_handler);

            TEST_CASE("1","nhXg̗vf0", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 0);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("constructor/destructor","constructor/destructor") {
        Singleton<Event_fortest::Handler::instance_list_type>::renewInstance();

        TEST_CASE("0","[O] nhXg̒g0", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 0);
        {
            EventHandler evhdr;
            TEST_CASE("1","nhXgɓo^Ă", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 1);
            TEST_CASE("2","o^Ă", *Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->begin() == &evhdr);
        }
        TEST_CASE("3","nh͉Ă", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 0);
    } END_CASE;

    BEGIN_CASE("raise","raise") {
        BEGIN_CASE("1","o^ÓIȃnhs") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();

            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","nhs",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","ԂŌĂϐ͓", &i == ptr_i_dummy_handler);
            TEST_CASE("3","lCNgĂ", i == 1);
        } END_CASE;

        BEGIN_CASE("2","o^CX^X̃nhs") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","nhs",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("2","ԂŌĂϐ͓", &i == evhdr.ptr_i);
            TEST_CASE("3","lCNgĂ", i == 1);
        } END_CASE;

        BEGIN_CASE("3"," (Ԃ͓ɋCɂȂ)") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;

            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","nhs",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","nhs",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("3","lCNgĂ", i == 2);
        } END_CASE;

        BEGIN_CASE("4","o^") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;
            EventHandler evhdr2;

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","nhs",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","nhs",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("3","lCNgĂ", i == 4);
        } END_CASE;
    } END_CASE;
}


#endif



