#!/bin/sh

# ひととおり自動処理するシェルスクリプト
# 次のフォルダ構成にした Cygwin で使うことを前提にしています。
# 
# ■ ~ (/home/ユーザー名)
# ├■ mplus_outline_fonts (M+ OUTLINE FONTS の cvs 版。必要なければ省いていい)
# ├■ mplus_outline_fonts-l (Rounded-L M+)
# ├■ mplus_outline_fonts-m (Rounded M+)
# ├■ mplus_outline_fonts-x (Rounded-X M+)
# ├■ work (Subversion リポジトリの work ディレクトリへのシンボリックリンク)
# └■ allbuildver.txt (TESTFLIGHT のバージョンを記載)

# ---------------------------------------------------------------------------
# 初期設定
# ---------------------------------------------------------------------------
YEAR=`date '+%Y'`
DATE=`date '+%Y%m%d'`
TESTFLIGHTVER=`cat ~/allbuildver.txt`
HOMEPATH=~
WORKPATH=$HOMEPATH/work


# ---------------------------------------------------------------------------
# <rect fill="none"> を含まない svg がないかを確認
# ---------------------------------------------------------------------------
CheckSVG(){

if [ -e $HOMEPATH/allbuildcheck.txt ]; then
  rm $HOMEPATH/allbuildcheck.txt
fi
echo Checking svg files ...
find $HOMEPATH/mplus_outline_fonts/svg.d -name '*.svg'   | xargs grep -L 'fill="none"' >> $HOMEPATH/allbuildcheck.txt
find $HOMEPATH/mplus_outline_fonts-m/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> $HOMEPATH/allbuildcheck.txt
find $HOMEPATH/mplus_outline_fonts-x/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> $HOMEPATH/allbuildcheck.txt
find $HOMEPATH/mplus_outline_fonts-l/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> $HOMEPATH/allbuildcheck.txt

if [ -s $HOMEPATH/allbuildcheck.txt ]; then
  cat $HOMEPATH/allbuildcheck.txt
  echo 上記ファイルに文字分割用の枠線 rect タグが見つかりません.
  echo Illustrator で再出力してください.
  exit
fi

rm $HOMEPATH/allbuildcheck.txt
echo done.

}


# ---------------------------------------------------------------------------
# 日付をもとに configdate.py の生成
# ---------------------------------------------------------------------------
GenerateConfig(){

echo year = \"$YEAR\" > $HOMEPATH/configdate.py
echo version = \"1.$TESTFLIGHTVER.$DATE\" >> $HOMEPATH/configdate.py
cp $HOMEPATH/configdate.py $HOMEPATH/mplus_outline_fonts-m/scripts
cp $HOMEPATH/configdate.py $HOMEPATH/mplus_outline_fonts-l/scripts
cp $HOMEPATH/configdate.py $HOMEPATH/mplus_outline_fonts-x/scripts
cp $HOMEPATH/configdate.py $HOMEPATH/mplus_outline_fonts/scripts/config.py

}


# ---------------------------------------------------------------------------
# Rounded M+ 生成
# ---------------------------------------------------------------------------
BuildRoundedMPlus(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Building Rounded$2 M+"
cd $HOMEPATH/mplus_outline_fonts-$1
make MPLUS_FULLSET=yes SPLIT_CONCURRENCY=2 -j2 &> log.txt
cd release
make
echo done.

}

# ---------------------------------------------------------------------------
# Rounded M+ workにコピー
# ---------------------------------------------------------------------------
CopyWorkRoundedMPlus(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Copy to Work Rounded$2 M+"
rm $WORKPATH/$1/*.ttf
cp $HOMEPATH/mplus_outline_fonts-$1/release/fonts/* $WORKPATH/$1
echo done.

}


# ---------------------------------------------------------------------------
# M+ 生成
# ---------------------------------------------------------------------------
BuildMPlus(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Building M+"
cd $HOMEPATH/mplus_outline_fonts
make MPLUS_FULLSET=yes SPLIT_CONCURRENCY=2 -j2 &> log.txt
cd release
rm *.tar.xz
rm -rf mplus-TESTFLIGHT*
make
echo done.

}


# ---------------------------------------------------------------------------
# 生成した M+ のアーカイブを再度解凍して work にコピー & 配布用アーカイブの作成
# ---------------------------------------------------------------------------
CopyWorkMPlus(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Copy to work M+"
cd $HOMEPATH/mplus_outline_fonts/release
rm $WORKPATH/limited/*.ttf
cp -f mplus-TESTFLIGHT-*.tar.xz $WORKPATH/archives/mplus-$DATE.tar.xz
tar Jxvf mplus-TESTFLIGHT-*.tar.xz
cp mplus-TESTFLIGHT-*/*.ttf $WORKPATH/limited
rm -rf mplus-TESTFLIGHT*
echo done.

}


# ---------------------------------------------------------------------------
# 配布用アーカイブの作成
# ---------------------------------------------------------------------------
MakeArchives(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Making distribution archives"
cd $WORKPATH
./allzip.bat
echo done.

}


# ---------------------------------------------------------------------------
# limited 版フォントの生成
# ---------------------------------------------------------------------------
GenerateLimited(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Generating limited fonts"
cp $WORKPATH/m/*.ttf $WORKPATH/limited
cp $WORKPATH/l/*.ttf $WORKPATH/limited
cp $WORKPATH/x/*.ttf $WORKPATH/limited
cd $WORKPATH/limited
./limited.sh
echo done.

}


# ---------------------------------------------------------------------------
# limited 版フォントの配布用アーカイブの作成
# ---------------------------------------------------------------------------
ArchiveLimited(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Archiving limited fonts"
cd $WORKPATH/limited
./release.bat
echo done.

}


# ---------------------------------------------------------------------------
# 生成したアーカイブを日付フォルダに整理
# ---------------------------------------------------------------------------
MoveArchives(){

cd $WORKPATH/archives
mkdir rounded-mplus-$DATE
mv -f *$DATE.* rounded-mplus-$DATE

}


# ---------------------------------------------------------------------------
# コンピュータをスリープする
# ---------------------------------------------------------------------------
ShutDownNow(){

echo `date +'%Y/%m/%d %H:%M:%S'` ": Completed. Shutdown now !"
shutdown -p now

}

# ---------------------------------------------------------------------------

# SVG の枠線チェック
CheckSVG

# きょうの日付から Config の作成
GenerateConfig

# Rounded M+ のビルドと work へのコピー
BuildRoundedMPlus m
CopyWorkRoundedMPlus m
BuildRoundedMPlus x -X
CopyWorkRoundedMPlus x -X
BuildRoundedMPlus l -L
CopyWorkRoundedMPlus l -L

# M+ のビルドと work へのコピー
BuildMPlus
CopyWorkMPlus

# 配布用アーカイブの作成
MakeArchives

# Limited 版フォントと配布用アーカイブの作成
GenerateLimited
ArchiveLimited

# アーカイブの整理
MoveArchives

# コンピュータをスリープする
# ShutDownNow
