#!/bin/sh

# ひととおり自動処理するシェルスクリプト
# 次のフォルダ構成にした Cygwin で使うことを前提にしています。
# 
# ■ ~ (/home/ユーザー名)
# ├■ mplus_outline_fonts (M+ OUTLINE FONTS の cvs 版。必要なければ省いていい)
# ├■ mplus_outline_fonts-l (Rounded-L M+)
# ├■ mplus_outline_fonts-m (Rounded M+)
# ├■ mplus_outline_fonts-x (Rounded-X M+)
# ├■ work (Subversion リポジトリの work ディレクトリへのシンボリックリンク)
# └■ allbuildver.txt (TESTFLIGHT のバージョンを記載)

# 初期設定
YEAR=`date '+%Y'`
DATE=`date '+%Y%m%d'`
TESTFLIGHTVER=`cat ~/allbuildver.txt`


# <rect fill="none"> を含まない svg がないかを確認
if [ -e ~/allbuildcheck.txt ]; then
  rm ~/allbuildcheck.txt
fi
echo Checking svg files ...
find ~/mplus_outline_fonts/svg.d -name '*.svg'   | xargs grep -L 'fill="none"' >> ~/allbuildcheck.txt
find ~/mplus_outline_fonts-m/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> ~/allbuildcheck.txt
find ~/mplus_outline_fonts-x/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> ~/allbuildcheck.txt
find ~/mplus_outline_fonts-l/svg.d -name '*.svg' | xargs grep -L 'fill="none"' >> ~/allbuildcheck.txt

if [ -s ~/allbuildcheck.txt ]; then
  cat ~/allbuildcheck.txt
  echo 上記ファイルに文字分割用の枠線 rect タグが見つかりません.
  echo Illustrator で再出力してください.
  exit
fi

rm ~/allbuildcheck.txt
echo done.


# 日付をもとに configdate.py の生成
echo year = \"$YEAR\" > ~/configdate.py
echo version = \"1.$TESTFLIGHTVER.$DATE\" >> ~/configdate.py
cp ~/configdate.py ~/mplus_outline_fonts-m/scripts
cp ~/configdate.py ~/mplus_outline_fonts-l/scripts
cp ~/configdate.py ~/mplus_outline_fonts-x/scripts
cp ~/configdate.py ~/mplus_outline_fonts/scripts/config.py


# Rounded M+ 生成 & workにコピー
echo `date +'%Y/%m/%d %H:%M:%S'` ": Building Rounded M+"
cd ~/mplus_outline_fonts-m
make MPLUS_FULLSET=yes &> log.txt
cd release
make
rm ../../work/m/*.ttf
cp fonts/* ../../work/m
echo done.


# Rounded-X M+ 生成 & workにコピー
echo `date +'%Y/%m/%d %H:%M:%S'` ": Building Rounded-X M+"
cd ~/mplus_outline_fonts-x
make MPLUS_FULLSET=yes &> log.txt
cd release
make
rm ../../work/x/*.ttf
cp fonts/* ../../work/x
echo done.


# Rounded-L M+ 生成 & workにコピー
echo `date +'%Y/%m/%d %H:%M:%S'` ": Building Rounded-L M+"
cd ~/mplus_outline_fonts-l
make MPLUS_FULLSET=yes &> log.txt
cd release
make
rm ../../work/l/*.ttf
cp fonts/* ../../work/l
echo done.


# M+ 生成
echo `date +'%Y/%m/%d %H:%M:%S'` ": Building M+"
cd ~/mplus_outline_fonts
make MPLUS_FULLSET=yes &> log.txt
cd release
rm *.tar.xz
rm -rf mplus-TESTFLIGHT*
make
echo done.


# 生成した M+ のアーカイブを再度解凍して work にコピー
rm ~/work/limited/*.ttf
cp -f mplus-TESTFLIGHT-*.tar.xz ~/work/archives/mplus-$DATE.tar.xz
tar Jxvf mplus-TESTFLIGHT-*.tar.xz
cp mplus-TESTFLIGHT-*/*.ttf ~/work/limited
rm -rf mplus-TESTFLIGHT*


# 配布用アーカイブの作成
echo `date +'%Y/%m/%d %H:%M:%S'` ": Making distribution archives"
cd ~/work
./allzip.bat
echo done.


# limited 版フォントの生成
echo `date +'%Y/%m/%d %H:%M:%S'` ": Create limited fonts"
cp ~/work/m/*.ttf ~/work/limited
cp ~/work/l/*.ttf ~/work/limited
cp ~/work/x/*.ttf ~/work/limited
cd ~/work/limited
./limited.sh
./release.bat
echo done.


# スタンバイ
echo `date +'%Y/%m/%d %H:%M:%S'` ": Completed. Shutdown now !"
shutdown -p now
