#pragma once

//! @file Mix/Standard.h
//! @brief X^_[hCN[ht@C

/*!
@mainpage Mainpage
CũCy[WłB<br>
͂߂Ă̕ @subpage intro_page 炨ǂ݂B<br>
܂ACugpăAvP[V쐬ۂ̃qgƂ @subpage tips_page B<br>
<ul>
	<li>Mix</li><br>
	[g<br>
	<li>Mix::Dynamics</li><br>
	V~[V<br>
	<li>Mix::File</li><br>
	t@C̓o<br>
	<li>Mix::Geometry</li><br>
	AʁA( OBB AABB )AȂǂ̊ȈՌ`<br>
	<li>Mix::Graphics</li><br>
	DirectGraphics ̃bp[<br>
	<li>Mix::Graphics::Utility</li><br>
	OtBbNX̃[eBeB<br>
	<li>Mix::Input</li><br>
	L[{[hA}EXAQ[pbhȂǂ̓<br>
	<li>Mix::Memory</li><br>
	̑<br>
	<li>Mix::Network</li><br>
	TCP/IP gpNCAgAT[o[̍쐬<br>
	<li>Mix::Scene</li><br>
	_Ci~NXAOtBbNX𓝍RcV[̍쐬<br>
	<li>Mix::Sound</li><br>
	TEh̍Đ<br>
</ul>
*/

/*!
@page intro_page Introduction

@section creProj_sec Create a project

@subsection creProj_hello_subsec ͂߂
Microsoft Visual Studio 2008 Express gƂOƂĂ܂B<br>
̑Jł͈قȂꍇ܂̂ŁAӂB<br>

@subsection creProj_app_subsec AvP[V̐ݒ
Cj[́ut@CvuVK쐬vuvWFNgvIA_CAOJĂB<br>
uWin32 R\[AvP[VvIAuWindows AvP[Vv쐬܂B<br>
u\[VGNXv[[ṽvWFNgENbNAReLXgj[́uvpeBvIA<br>
u\vpeBv̈ȉ̍ڂݒ肵ĂB<br>

@par uC/C++v
uSʁv́uǉ̃CN[hfBNgv "Mix\Release\Engine\include" ǉ܂B<br>

@par uJv
uSʁv́uǉ̃CufBNgv "Mix\Release\Engine\lib\vs2008\x86" ǉ܂B1<br>
úv́uǉ̈ˑt@Cv "Mix.lib" ǉ܂B2<br>

@par urhCxgv
^C ( "*.dll" ) ̓AvP[V ( "*.exe" ) ƓfBNgɑ݂ĂKv邽߁A<br>
urhCxgv́uR}hCvɃ^CRs[R}h͂܂B<br>
copy "Mix\Release\Engine\runtime\vs2008\x86\Mix.dll" "AvP[V݂fBNg\Mix.dll" 3

1 Visual Studio ̃o[WɂĈقȂ܂<br>
2 fobȌꍇ "Mix_d.lib" ɂȂ܂<br>
3 fobȌꍇ "Mix_d.dll" ɂȂ܂<br>

@subsection newProj_run_subsec GW̏
ŏɎs WinMain ֐ƁA{IȃR[hLq܂B<br>

@code
#include "Mix/Standard.h"

int APIENTRY _tWinMain( HINSTANCE, HINSTANCE, LPTSTR, int )
{
    Mix::ENGINE_CONFIG engineConfig;

    if( Mix::Initialize( engineConfig ) == True )
    {
        Mix::IEngine* pEngine = Mix::GetEnginePtr();

        while( pEngine->Update() == True )
        {
            ;
        }

        Mix::Finalize();
    }

    return 0;
}
@endcode

@par  : Mix::Initialize
Mix::ENGINE_CONFIG \̂̐ݒ( ͋KlgpĂ܂ )gpAs܂B<br>
܂Aȍ~ Mix ̊eC^[tF[Xgpł悤ɂȂ܂B<br>

@parC[v : Mix::IEngine::Update
EBhẼbZ[WAt[[g̐Ae}l[W̍XVsĂ܂B<br>
܂ Mix::IEngine::Update  True ԂĂԂ͍XVpKv܂B<br>

@par  : Mix::Finalize
Mix::IEngine::Update  False ԂAC[v𔲂͉s܂B<br>
܂A擾A쐬C^[tF[X́AOɉĂB<br>
*/

/*!
@page tips_page Tips
<ul>
	<li>@subpage graphics_page "OtBbNX - Graphics"</li>
	<li>@subpage input_page "Cvbg - Input"</li>
	<li>@subpage scene_page "V[ - Scene"</li>
</ul>
*/

/*!
@page graphics_page Graphics

@section graphics_shaderModel_sec VF[_[fɂ
Mix ͕̃VF[_[fT|[gĂ܂B<br>
܂AGW̍쐬Ɏw肷VF[_[fɂĎgp DirectX ̃o[WA@\xقȂ܂B<br>
<table>
	<tr>
		<td></td>
		<th>DirectX ̃o[W</th>
		<th>@\x</th>
	</tr>
	<tr>
		<th align="left">VF[_[f3 1</th>
		<td align="center">DirectX9</td>
		<td align="center"></td>
	</tr>
	<tr>
		<th align="left">VF[_[f4 2</th>
		<td align="center">DirectX11</td>
		<td align="center">10.0</td>
	</tr>
	<tr>
		<th align="left">VF[_[f5 2</th>
		<td align="center">DirectX11</td>
		<td align="center">11.0</td>
	</tr>
</table>
<b>1 DirectX9 ɋ@\x͂܂</b><br>
<b>2 Windows Vista ͍XVvO( KB971644 )KpĂȂꍇ͓삵܂</b><br>
*/

/*! 
@page input_page Input

@section input_keyboard L[{[hɂ
SẴL[{[hɑΉꍇ́ANUMpbhȂǂ̈ˑL[͔̓͂ĂB<br>

@section input_mouse_subsec }EXɂ
ꕔ̃}EX(|CeBOfoCX)͓͂󂯕tȂ\܂B<br>
ݓ͂󂯂̂ƂĈȉ̂̂܂B<br>
<ul>
	<li>fXNgbvł̑΍WԂfoCX</li><br>
	}EXȂǁB<br>
	<li>zfXNgbvł̐΍WԂfoCX</li><br>
	y^ubgȂǁB<br>
</ul>

@section input_gamepad_subsec Q[pbhɂ
U@\͑ΉĂ܂B<br>
*/

/*!
@page scene_page Scene

@section scene_lighting_subsec CeBOɂ
Mix ł fBNViCgACgȂǂ̃V[Ŝɑ΂ăCeBOsCĝƂ<b>O[oCg</b>A<br>
|CgCgAX|bgCgȂǂ̕IɃCeBOsCĝƂ<b>[JCg</b>Ƒ̂Ă܂B<br>
<ul>
	<li>[JCgɂ</li><br>
	[JCg͕IȃCeBOs߁AV[ɔzuĂIuWFNgɑ΂Čʔ͈͂ɂ͂Ă邩ǂ𔻒肵܂B<br>
	܂[JCgɂ郉CeBO̓RXgAIuWFNgɑ΂ĂS{܂łKp邱ƂłȂ߁A<br>
	KvȂꍇ Mix::Scene::IEntity::SetLocalLighting \bh False ݒ肷邱Ƃ߂܂B<br>
</ul>

@section scene_refraction_subsec ܌ʂɂ
EH[^[^Cṽ}eAŃEF[uAj[V<b>܌</b>ɂĂꍇɋ@\܂B<br>
܂A܌ʂ͎_ɂ邩ǂ𔻒肵Ăs邽߁AV[ EH[^[v[ ( Mix::Scene::IWaterPool ) ǉA<br>
Mix::Scene::IWaterPool::SetRefraction \bh True ݒ肷Kv܂B<br>
<ul>
	<li>ʂ̃bVɂ</li>
	܂͓ȏł邽߁Aʂ̃bV( v[ł邱Ƃ]܂ ) XZ ɐɂȂ悤ɂĂB<br>
	XZʂɑ΂āAȂ̂͋܏삵܂̂ŒӂĂB<br>
	<li>IuWFNgzuۂ̒ӓ_</li><br>
	ÓIȃIuWFNg̏ꍇ Mix::Scene::IEntity::SetDefaultWaterContainsResult ŋܖʂƂ̈ʒu֌W炩ߐݒ肵ĂĂB<br>
	邱ƂɂĖt[AܖʂƂ̌sƂȂȂ邽߁AptH[}X悭Ȃ܂B<br>
	܂Aw̃}eݒ肳Ă郂fAEBWFbg͂ȂׂzuȂ悤ɂĂB<br>
	|S͓̊֌Wŋܖʂ̌ƑOɂQɕĕ`悷Kv邽ߎOAptH[}Xቺ܂B<br>
	܂AܖʂƏdȂĂꍇAܖʂ艺Aܖʂ̔|Š܌ʂ͍s܂A<br>
	ܖʂƏdȂĂ镔֐؂̂悤ɂȂrWAIɂ悭܂̂ŁAȂׂ̂悤Ȕzu͔ĂB<br>
</ul>
@section scene_optimizeWidget_subsec EBWFbg̍œK
EBWFbgɂ<b>v^[</b>A<b>p[eBN</b>ƕ܂A_[ł͓̂ƂĈďĂ܂B<br>
܂t[ v~eBu𐶐邽߁A|CgCg X|bgCgɂ郉CeBOA}eA̐ݒAp[eBN̔ʂɂƂȂp[tH[}Xɑ傫eyڂ܂B<br>
<ul>
	<li>v^[ɂ</li><br>
	}eA͐[x݂̏Ȃ ( Mix::Scene::IDefaultMaterial::IsZWrite() == False ) 悤ɂA<br>
	ꊇ` ( Mix::Scene::IMaterial::GetTransparencyMethod() == Mix::Scene::IMaterial::TM_LUMP )ɂ܂B<br>
	܂A[x̏݁Aꊇ`̐ݒ fGfB^[ Őݒ肷邱Ƃł܂B<br>
	<br>
	<li>p[eBNɂ</li><br>
	}eA<b>uh</b><b>Z</b>̏ꍇ́A[x݂̏Ȃ悤ɂAꊇ`ɂ܂B<br>
	ȊȌꍇ͒ʏ <b>|SPʂŕ`</b> ɂ܂B<br>
	܂p[eBÑXvCg͔ɕł邽߁AڂɂقǉeȂ悤łA<b>ꊇ`</b>𐄏܂B<br>
	<br>
	<li>X|bgCgA|CgCgɂ郉CeBOɂ</li><br>
	{Iɂ͍sȂ悤ɂ邱ƂƂœKłB<br>
	p[eBÑXvCg̓uh̊֌W牜OɌĕ`悳邽߁A<br>
	CeBÖقȂ̂ǂqɂȂ؂ւꍇA<b>啝ȃptH[}X̒ቺ</b>ɂȂ\܂B<br>
	܂_[ɂ͂̏Ԃɘa邽߂<b>CeBO[h</b>Ƃ@\Ă܂B<br>
	<br>
	<ul>
		<li>Default</li><br>
		fBNViCgACgɂ<b>O[oCeBO</b>݂̂ŁA<br>
		X|bgCgA|CgCgɂ<b>[JCeBO</b>͍s܂B<br>
		<li>Everyone</li><br>
		EɓĂSẴEBWFbgЂƂ܂Ƃ߂ɂA[JCeBOs܂B<br>
		܂A[JCeBOɎgpAX|bgCgA|CgCg̍v͂SɌ肳܂B<br>
		<li>Detailed</li><br>
		EBWFbgPʂŃ[JCeBOs܂B<br>
		[JCgɂ郉CeBO͉\Ȍ萳s܂AptH[}X͍ňłB<br>
	</ul>
</ul>

@section scene_posteffect_subsec |XgGtFNg
<ul>
	<li>ArGgIN[W</li><br>
	̂ɂՒfĂꏊɉe𗎂Ƃ܂B<br>
	܂AIuWFNg ( EBWFbg܂ ) ɑ΂Ďs邱Ƃ͂ł܂B<br>
	<li>VhE}bsO</li><br>
	̂̉e`ʂ܂B<br>
	܂Ap[eBN̉e͕`悷邱Ƃł܂B<br>
	<li>~mVeB</li><br>
	V[̋PxɂK␳s܂B<br>
	܂AÏɂAK␳ω܂B<br>
	<li>u[</li><br>
	V[̖邢Ǝv镔ɑ΂APAĂ邩̂悤Ȍʂ܂B<br>
	<li>CgVtg</li><br>
	̂̌Ԃ炳AؘR̂悤Ȍʂ܂B<br>
	܂ASbhCA䊂ƂĂ΂Ă܂B<br>
	<li>YtA</li><br>
	邢( zȂ )YɌēĂĂۂɔ˂JԂĂł̎ʂ肱݂\܂B<br>
	<li>tB~bN</li><br>
	ɁAPx( ~mVeB )ɂK␳ꂽV[( RGB̗vf 1.0 𒴂Ă )̐F𒲐邽߂̂̂łB<br>
	܂AKvɉ<b>K}␳</b>sKv܂B<br>
	<li>K}␳</li><br>
	V[̖邳𒲐܂B<br>
	<li>F</li><br>
	Yʉ߂ۂ̕Uɂ蔭F\܂B<br>
	܂Ǎʂ͉ʂ̎͂Ɍ܂B<br>
	<li>ʊE[x</li><br>
	œ_͈͂ɂAV[̎OƉɌďXɂڂʂ܂B<br>
	<li>cȎ</li><br>
	Ỷeɂʂcތʂ܂B<br>
	<li>Blbg</li><br>
	gCJŎBlȉʂ̎͂ރgȌʂ܂B<br>
	<li>A`GCAVO</li><br>
	WM[y܂B<br>
</ul>
*/

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CN[h
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Mix/Common.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// O
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{

	//! @struct FILE_CONFIG
	//! @brief t@Cݒ\
	struct FILE_CONFIG
	{
		const wchar_t* pRootDirectoryName;	//!< [gfBNg( NULL ̏ꍇ́AvZX̃JgfBNgɂȂ܂ )
		const wchar_t* pUserDirectoryName;	//!< [U[fBNg
	};

	//! @struct WINDOW_CONFIG
	//! @brief EBhEݒ\
	struct WINDOW_CONFIG
	{
		const wchar_t* pTitle;	//!< ^Cgo[ɕ\镶
		UInt32 width;			//!< 
		UInt32 height;			//!< 
		HICON hIcon;			//!< ACR̃nh
		HICON hIconSm;			//!< ACR()̃nh
		Boolean bAcceptDrop;	//!< hbv󂯓ꍇ True
	};

	//! @struct GRAPHICS_CONFIG
	//! @brief OtBbNXݒ\
	struct GRAPHICS_CONFIG
	{
		Mix::Graphics::SHADER_MODEL shaderModel;	//!< gpVF[_[f
		Boolean bFullscreen;						//!< tXN[ŋNꍇ True
		Boolean bWaitVSync;							//!< ҂ĕ`悷ꍇ True
	};

	//! @struct INPUT_CONFIG
	//! @brief ͐ݒ\
	struct INPUT_CONFIG
	{
		Boolean bUseKeyboard;	//!< L[{[h( Mix::Peripheral::IKeyboard )gpꍇ True
		Boolean bUseMouse;		//!< }EX( Mix::Peripheral::IMouse )gpꍇ True
		Boolean bUseGamepad;	//!< Q[pbh( Mix::Peripheral::IGamepad )gpꍇ True
	};

	//! @struct ENGINE_CONFIG
	//! @brief GWݒ\
	struct ENGINE_CONFIG
	{
		Boolean bUseFile;			//!< t@C@\( Mix::IO )gpꍇ True<br>uTEhvuOtBbNXv@\gpꍇ́AK True w肵Ă
		Boolean bUseInput;			//!< ͋@\( Mix::Input )gpꍇ True
		Boolean bUseDynamics;		//!< _Ci~NX@\( Mix::Dynamics )gpꍇ True
		Boolean bUseGraphics;		//!< OtBbNX@\( Mix::Graphics )gpꍇ True
		Boolean bUseSound;			//!< TEh@\( Mix::Sound )gpꍇ True
		Boolean bUseScene;			//!< V[@\( Mix::Scene )gpꍇ True
		Boolean bUseNetwork;		//!< lbg[N@\( Mix::Network )gpꍇ True

		//! @brief b̃t[<br>
		//! ( frameRate > 0 )  : b̃t[𐧌AFPSv܂<br>
		//! ( frameRate == 0 ) : b̃t[𐧌AFPSv܂<br>
		//! ( frameRate < 0 )  : b̃t[𐧌AFPSv܂
		Int32 baseFPS;
		//! @brief t[ɋ󂫎Ԃꍇɑ̃XbhɃ^CXCX( Sleep( 0 ) )t[
		Int32 insomniaFrames;

		WINDOW_CONFIG window;		//!< EBhE̐ݒ<br>OEBhEgpꍇ( hWnd != NULL )͖܂
		FILE_CONFIG file;			//!< t@C̐ݒ
		INPUT_CONFIG input;			//!< ͂̐ݒ<br>͋@\gpȂ( bUseInput == False )ꍇ͖܂
		GRAPHICS_CONFIG graphics;	//!< OtBbNX̐ݒ<br>OtBbNX@\gpȂꍇ( bUseGraphics == False )͖܂

		//! @brief RXgN^
		ENGINE_CONFIG( void )
		{
			bUseFile = True;
			bUseInput = True;
			bUseDynamics = True;
			bUseSound = True;
			bUseGraphics = True;
			bUseScene = True;
			bUseNetwork = True;

			baseFPS = 60;
			insomniaFrames = 15;

			window.pTitle = NULL;
			window.width = 1024;
			window.height = 768;
			window.hIcon = NULL;
			window.hIconSm = NULL;
			window.bAcceptDrop = False;

			file.pRootDirectoryName = NULL;
			file.pUserDirectoryName = NULL;

			input.bUseKeyboard = True;
			input.bUseMouse = True;
			input.bUseGamepad = True;

			graphics.shaderModel = Mix::Graphics::SHADER_MODEL_3;
			graphics.bFullscreen = False;
			graphics.bWaitVSync = False;
		}
	};

	//! @brief Mix܂
	//! @return ꍇ True Ԃ܂
	_MIX_DLL_API Boolean Initialize( const Mix::ENGINE_CONFIG& config );
	//! @brief MixI܂
	_MIX_DLL_API void Finalize( void );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CN[h
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Mix/IEngine.h"
