#pragma once

//! @file Mix/Sound/IManager.h
//! @brief TEh}l[W[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Sound{

	//! @class IManager
	//! @brief TEh}l[W[C^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief vOC[h܂
		//! @param[in] pFileName [hvOC̃t@C
		//! @return ꍇ True Ԃ܂
		virtual Boolean LoadPlugin( const wchar_t* pFileName ) = 0;

		//! @brief X^eBbNRg[[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppController 쐬X^eBbNRg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateStaticController( const wchar_t* pFilePath, Mix::Sound::IController** ppController ) = 0;
		//! @brief X^eBbNRg[[쐬܂
		//! @param[in] pReader Mix::File::IReader C^[tF[X̃|C^
		//! @param[out] ppController 쐬X^eBbNRg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note X^eBbNRg[[̍쐬ɐꍇApReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStaticController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController ) = 0;

		//! @brief Xg[Rg[[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[in] bBuffered t@CɊi[čĐꍇ True
		//! @param[out] ppController 쐬Xg[Rg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateStreamController( const wchar_t* pFilePath, Boolean bBuffered, Mix::Sound::IController** ppController ) = 0;
		//! @brief Xg[Rg[[쐬܂
		//! @param[in] pReader Mix::File::IReader C^[tF[X̃|C^
		//! @param[out] ppController Xg[Rg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[Rg[[̍쐬ɐꍇApReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController ) = 0;

		//! @brief Xi[쐬܂
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppListener 쐬Xi[n Mix::Sound::IListener C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateListener( const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IListener** ppListener, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief X^eBbNG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬X^eBbNG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note X^eBbNG~b^[̍쐬ɐꍇApListener ̎QƃJE^ +1 ܂
		virtual Boolean CreateStaticEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;
		//! @brief X^eBbNG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pReader Mix::File::IReader C^[tF[X̃|C^
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬X^eBbNG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note X^eBbNG~b^[̍쐬ɐꍇApListener pReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStaticEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;

		//! @brief Xg[G~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] bBuffered t@CɊi[čĐꍇ True
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬Xg[G~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[G~b^[̍쐬ɐꍇApListener ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, Boolean bBuffered, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;
		//! @brief Xg[G~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pReader Mix::File::IReader C^[tF[X̃|C^
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬Xg[G~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[G~b^[̍쐬ɐꍇApListener pReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;
	};

}}
