#pragma once

//! @file Mix/Sound/IListener.h
//! @brief Xi[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Sound{

	//! @class IListener
	//! @brief Xi[C^[tF[X
	class IListener : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IListener( void ){}

	public:
		//! @brief [J̑OxNg擾܂
		//! @return [J̑OxNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLocalFront( void ) const = 0;
		//! @brief [J̏xNg擾܂
		//! @return [J̏xNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLocalUp( void ) const = 0;

		//! @brief [h̑OxNg擾܂
		//! @return [h̑OxNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetWorldFront( void ) const = 0;
		//! @brief [h̏xNg擾܂
		//! @return [h̏xNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetWorldUp( void ) const = 0;

		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] mat [hs\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& mat ) = 0;

		//! @brief b̈ړx擾܂
		//! @return b̈ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetVelocity( void ) const = 0;
		//! @brief b̈ړxݒ肵܂
		//! @param[in] velocity b̈ړx\ Mix::Vector3 NX
		//! @note hbv[ʂɉe^܂B
		virtual void SetVelocity( const Mix::Vector3& velocity ) = 0;
	};

}}
