#pragma once

//! @file Mix/Sound/IEmitter.h
//! @brief G~b^[C^[tFXCN[ht@C

#include "Mix/Sound/IDevice.h"

namespace Mix{ namespace Sound{

	//! @class IEmitter
	//! @brief G~b^[C^[tF[X
	class IEmitter : public Mix::Sound::IDevice
	{
	protected:
		//! @brief fXgN^
		virtual ~IEmitter( void ){}

	public:
		//! @brief [J̑OxNg擾܂
		//! @return [J̑OxNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLocalFront( void ) const = 0;
		//! @brief [J̏xNg擾܂
		//! @return [J̏xNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLocalUp( void ) const = 0;

		//! @brief [h̑OxNg擾܂
		//! @return [h̑OxNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetWorldFront( void ) const = 0;
		//! @brief [h̏xNg擾܂
		//! @return [h̏xNg\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetWorldUp( void ) const = 0;

		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] mat [hs\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& mat ) = 0;

		//! @brief b̈ړx擾܂
		//! @return b̈ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetVelocity( void ) const = 0;
		//! @brief b̈ړxݒ肵܂
		//! @param[in] velocity b̈ړx\ Mix::Vector3 NX
		//! @note hbv[ʂɉe^܂B
		virtual void SetVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief `l擾܂
		//! @return `lԂ܂
		virtual UInt32 GetChannelCount( void ) const = 0;

		//! @brief `l̔a擾܂
		//! @return `l̔aԂ܂
		virtual Float32 GetChannelRadius( void ) const = 0;
		//! @brief `l̔aݒ肵܂
		//! @param[in] radius `l̔a( 0.0f`̖ )
		//! @note [hW̃ItZbgӖ܂
		virtual void SetChannelRadius( Float32 radius ) = 0;

		//! @brief `l̕ʊe擾܂
		//! @param[in] channel `l
		//! @return `l̕ʊeԂ܂
		virtual Float32 GetChannelAzimuth( UInt32 channel ) const = 0;
		//! @brief `l̕ʊeݒ肵܂
		//! @param[in] channel `l
		//! @param[in] azimuth ʊe( 0.0f`MIX_2PI )
		//! @note xNgƂ]Ӗ܂
		virtual void SetChannelAzimuth( UInt32 channel, Float32 azimuth ) = 0;

		//! @brief hbv[ʂ̃XP[[擾܂
		//! @return XP[[Ԃ܂
		virtual Float32 GetDopplerScaler( void ) const = 0;
		//! @brief hbv[ʂ̃XP[[ݒ肵܂
		//! @param[in] scaler XP[[( 0.0f`̖ )
		virtual void SetDopplerScaler( Float32 scaler ) = 0;

		//! @brief XV܂
		//! @note Xi[( Mix::Sound::IListener )̃p[^ύXꂽꍇ̃\bhsKv܂
		virtual void Update( void ) = 0;

		//! @brief ł邩ǂ擾܂
		//! @return łꍇ True Ԃ܂
		virtual Boolean IsCloneable( void ) const = 0;
		//! @brief g𕡐܂
		//! @param[out] ppEmitter G~b^[n Mix::Sound::IEmitter C^[tF[X̃|C^̃AhX
		virtual Boolean Clone( Mix::Sound::IEmitter** ppEmitter ) = 0;
	};

}}
