#pragma once

//! @file Mix/Sound/IDevice.h
//! @brief foCXC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Sound{

	//! @class IDevice
	//! @brief foCXC^[tF[X
	class IDevice : public Mix::Reference
	{
	public:
		//! @enum STATUS
		//! @brief Xe[^X񋓒萔
		enum STATUS
		{
			//! @brief ~
			STOPPED		= 0, 

			//! @brief 
			//! @note
			//! Đ( Play )̏( Xg[Đ̏ꍇ̂ )\܂B<br>
			//! ܂̌ PLAYING  STOPPED( G[ꍇ ) Ɉȍ~܂B
			PREPARATION	= 1,

			//! @brief Đ
			PLAYING		= 2,
		};

	protected:
		//! @brief fXgN^
		virtual ~IDevice( void ) {}

	public:
		//! @brief Đǂ擾܂
		//! @return Đ̏ꍇ True Ԃ܂
		//! @note ( GetStatus ) PREPARATION  PLAYING ̏ꍇ̂Ƃ\܂B
		virtual Boolean IsPlaying( void ) = 0;
		//! @brief Đ܂
		//! @param[in] bLoop [vĐꍇ True w肵܂
		virtual void Play( Boolean bLoop = False ) = 0;
		//! @brief ~܂
		virtual void Stop( void ) = 0;

		//! @brief ꎞ~܂
		virtual void Suspend( void ) = 0;
		//! @brief ꎞ~܂
		virtual void Resume( void ) = 0;

		//! @brief t@CpX擾܂
		//! @return t@CpXԂ܂
		virtual const wchar_t* GetFilePath( void ) const = 0;
	};

}}
