#pragma once

//! @file Mix/Scene/ISpotLight.h
//! @brief X|bgCgC^[tF[XCN[ht@C

#include "Mix/Scene/ILocalLight.h"

namespace Mix{ namespace Scene{

	//! @class ISpotLight
	//! @brief X|bgCgC^[tF[X
	class ISpotLight : public Mix::Scene::ILocalLight
	{
	protected:
		//! @brief fXgN^
		virtual ~ISpotLight( void ){}

	public:
		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetDirection( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] dir \ Mix::Vector3 NX
		virtual void SetDirection( const Mix::Vector3& dir ) = 0;

		//! @brief e^͈͂擾܂
		//! @return e^͈͂Ԃ܂
		virtual Float32 GetRange( void ) const = 0;
		//! @brief e^͈͂ݒ肵܂
		//! @param[in] range e^͈
		virtual void SetRange( Float32 range ) = 0;

		//! @brief R[̓p擾܂
		//! @return R[̓pԂ܂
		virtual Float32 GetConeInnerAngle( void ) const = 0;
		//! @brief R[̊Op擾܂
		//! @return R[̊OpԂ܂
		virtual Float32 GetConeOuterAngle( void ) const = 0;
		//! @brief R[̐ݒ܂
		//! @param[in] innerAngle R[̓p( WAP )
		//! @param[in] outerAngle R[̊Op( WAP )
		virtual void SetCone( Float32 innerAngle, Float32 outerAngle ) = 0;

		//! @brief X|bgCgۂ̋P̉s擾܂
		//! @return P̉sԂ܂
		virtual Float32 GetExponent( void ) const = 0;
		//! @brief X|bgCgۂ̋P̉s(nCCg)ݒ肵܂
		//! @param[in] exp P̉s( 0.0f`̖ )
		virtual void SetExponent( Float32 exp ) = 0;
	};

}}
