#pragma once

//! @file Mix/Scene/IPlanter.h
//! @brief v^[C^[tF[XCN[ht@C

#include "Mix/Scene/IWidget.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{

	//! @class IPlanter
	//! @brief v^[C^[tF[X
	class IPlanter : public Mix::Scene::IWidget
	{
	public:
		//! @enum GRASS_QUALITY
		//! @brief OXNHeB񋓒萔
		enum GRASS_QUALITY
		{
			GQ_SIMPLE	= 0,	//!< Vv( P̃|S )
			GQ_CROSS1	= 1,	//!< NXP( Q̃|S̃NX )
			GQ_CROSS2	= 2,	//!< NXQ( R̃|S̃NX )
		};

		//! @struct GRASS_MODEL
		//! @brief OXf\
		struct GRASS_MODEL
		{
			Mix::Vector2 uv[2];	//!< OXɓ\teNX`̍( uv[0] )ƉE( uv[1] )UVW
			GRASS_QUALITY quality; //!< NHeB\ Mix::Scene::IPlanter::GRASS_QUALITY 񋓒萔
		};

		//! @struct GRASS_UNIT
		//! @brief OXjbg\
		struct GRASS_UNIT
		{
			Mix::Matrix4x4 worldMat;	//!< [hs\ Mix::Matrix4x4 NX
			UInt32 modelIndex;			//!< f( GRASS_MODEL \̂̔z )̃CfbNX
		};

	protected:
		//! @brief fXgN^
		virtual ~IPlanter( void ) {}

	public:
		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB Ԃ܂
		virtual const Mix::Geometry::AABB& GetBounds( void ) const = 0;

		//! @brief OǂmF܂
		//! @return Ȍꍇ True Ԃ܂
		//! @note OƂ͕`攻Ɏgp锪؂͈̔͂𒴂ĔzuĂԂ̂Ƃ\܂B
		virtual Boolean IsIgnored( void ) const = 0;
	};

}}
