#pragma once

//! @file Mix/Scene/ILocalLight.h
//! @brief [JCgC^[tF[XCN[ht@C

#include "Mix/Scene/ILight.h"
#include "Mix/Geometry/Sphere.h"

namespace Mix{ namespace Scene{

	//! @class ILocalLight
	//! @brief [JCgC^[tF[X
	class ILocalLight : public Mix::Scene::ILight
	{
	protected:
		//! @brief fXgN^
		virtual ~ILocalLight( void ) {}

	public:
		//! @brief F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetColor( void ) const = 0;
		//! @brief Cg̐Fݒ肵܂
		//! @param[in] color Cg̐F\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& color ) = 0;

		//! @brief `W擾܂
		//! @return `WԂ܂
		virtual Float32 GetLinearAttenuation( void ) const = 0;
		//! @brief 2W擾܂
		//! @return 2WԂ܂
		virtual Float32 GetQuadraticAttenuation( void ) const = 0;
		//! @brief wW擾܂
		//! @return wWԂ܂
		virtual Float32 GetExponentAttenuation( void ) const = 0;
		//! @brief Wݒ肵܂
		//! @param[in] l `W( 0.0f`̖ )
		//! @param[in] q 2W( 0.0f`̖ )
		//! @param[in] e wW( 0.0f`̖ )
		//! @note l̎ l + q * d + e * d2 ( d=_烉Cg܂ł̋ d2=d*d )
		virtual void SetAttenuation( Float32 l, Float32 q, Float32 e ) = 0;

		//! @brief ʒu擾܂
		//! @return ʒu\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetPosition( void ) const = 0;
		//! @brief ʒuݒ肵܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @note ʒuύXꍇ́AtbV( Refresh )ĂB
		virtual void SetPosition( const Mix::Vector3& pos ) = 0;

		//! @brief tbV܂
		//! @note ʒuύXꍇɎsĂB
		virtual void Refresh( void ) = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::Sphere NXԂ܂
		virtual const Mix::Geometry::Sphere& GetBounds() const = 0;

		//! @brief C[KǂmF܂
		//! @return C[Kȏꍇ True Ԃ܂
		//! @note
		//! C[KƂ̓V[_[̍쐬̐ݒ( Mix::Scene::RENDERER_CONFIG )ɂA؂͈̔͂𒴂Ă邱Ƃ\܂B<br>
		//! ܂ȀԂɂȂꍇ́AʒuĐݒ肷邩AV[_[폜邱Ƃ𐄏܂B
		virtual Boolean IsIllegal( void ) const = 0;
	};

}}
