#pragma once

//! @file Mix/Scene/IGhost.h
//! @brief S[XgC^[tF[XCN[ht@C

#include "Mix/Scene/IRendererResource.h"

namespace Mix{ namespace Scene{

	//! @class IGhost
	//! @brief S[XgC^[tF[X
	class IGhost : public Mix::Scene::IRendererResource
	{
	protected:
		//! @brief fXgN^
		virtual ~IGhost( void ) {}

	public:
		//! @brief _Ci~NXIuWFNg擾܂
		//! @param[out] ppDynamicsObject 擾_Ci~NXIuWFNgn Mix::Scene::IDynamiscObject C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾_Ci~NXIuWFNg͎QƃJE^ +1 ܂
		virtual Boolean GetDynamicsObject( Mix::Scene::IDynamicsObject** ppDynamicsObject ) = 0;

		//! @brief LɂȂĂ邩ǂ擾܂
		//! @return LɂȂĂꍇ True Ԃ܂
		virtual Boolean IsEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetEnabled( Boolean state ) = 0;

		//! @brief [h̉]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual Mix::Quaternion GetWorldRotation( void ) const = 0;
		//! @brief [h̉]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetWorldRotation( const Mix::Quaternion& rot ) = 0;

		//! @brief [ḧʒu擾܂
		//! @return ]\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetWorldPosition( void ) const = 0;
		//! @brief [ḧʒuݒ肵܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		virtual void SetWorldPosition( const Mix::Vector3& pos ) = 0;

		//! @brief [hs擾܂
		//! @return s\ Mix::Matrix4x4 NXԂ܂
		virtual Mix::Matrix4x4 GetWorldMatrx( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] mat s\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& mat ) = 0;

		//! @brief tbVKvǂmF܂
		//! @return tbVKvȏꍇ True Ԃ܂
		//! @note
		//! Ll}eBbNS[Xg̏ꍇ̂ True Ԃ܂B<br>
		//! ȊȌꍇ False Ԃ܂
		virtual Boolean NeedsRefresh( void ) const = 0;
		//! @brief tbV܂
		//! @note
		//! Ll}eBbNS[Xĝ݂̏ɂȂ܂B<br>
		//! ܂Ã\bh Mix::Scene::IRenderer::Update ɌĂяoKv܂B
		virtual void Refresh( void )  = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;

		//! @brief fobO : `悷ۂ̂擾܂
		//! @return `悷ۂ̃XP[Ԃ܂
		virtual Float32 Debug_GetDrawAxisScaling( void ) const = 0;
		//! @brief fobO : `悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling `悷ۂ̃XP[( 0.0fȏ )
		virtual void Debug_SetDrawAxisScaling( Float32 scaling ) = 0;
	};

}}
