#pragma once
#pragma once

//! @file Mix/Scene/IGhost.h
//! @brief S[XgC^[tF[XCN[ht@C

#include "Mix/Scene/IRendererResource.h"

namespace Mix{ namespace Scene{

	//! @class IFloor
	//! @brief tAC^[tF[X
	class IFloor : public Mix::Scene::IRendererResource
	{
	protected:
		//! @brief fXgN^
		virtual ~IFloor( void ) {}

	public:
		//! @brief _Ci~NXIuWFNg擾܂
		//! @param[out] ppDynamicsObject 擾_Ci~NXIuWFNgn Mix::Scene::IDynamicsObject C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note
		//! 擾_Ci~NXIuWFNg( Mix::Scene::ISimpleCollider )̎QƃJE^ +1 ܂B<br>
		virtual Boolean GetDynamicsObject( Mix::Scene::IDynamicsObject** ppDynamicsObject ) = 0;

		//! @brief [h̉]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual Mix::Quaternion GetWorldRotation( void ) const = 0;
		//! @brief [h̉]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetWorldRotation( const Mix::Quaternion& rot ) = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;

		//! @brief C[t[̃C̊Ԋu擾܂
		//! @return C̊ԊuԂ܂
		virtual Float32 Debug_GetDrawInterval( void ) const = 0;
		//! @brief C[t[̃C̊Ԋuݒ肵܂
		//! @param[in] interval C̊Ԋu
		virtual void Debug_SetDrawInterval( Float32 interval ) = 0;

		//! @brief C[t[̍L擾܂
		//! @return LԂ܂
		virtual UInt32 Debug_GetDrawExtent( void ) const = 0;
		//! @brief C[t[̍Lݒ肵܂
		//! @param[in] extent L
		//! @note ۂ̍L( C̊Ԋu * ( L + 1 ) )ɂȂ܂
		virtual void Debug_SetDrawExtent( UInt32 extent ) = 0;
	};

}}
