#pragma once

//! @file Mix/Scene/IFactory.h
//! @brief t@Ng[C^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Scene/IDefaultParticleSystem.h"

namespace Mix{ namespace Scene{

	//! @class IFactory
	//! @brief t@Ng[C^[tF[X
	class IFactory : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IFactory( void ) {}

	public:
		//! @brief _[쐬܂
		//! @param[in] config _[̐ݒ\ Mix::Scene::RENDERER_CONFIG \
		//! @param[in] ppRenderer 쐬_[n Mix::Scene::IRenderer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, Mix::Scene::IRenderer** ppRenderer, const wchar_t* pDebugName ) = 0;

		//! @brief }eAt@C쐬܂
		//! @param[in] pFilePath }eÃt@CpX
		//! @param[out] ppMaterial 쐬}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateMaterialFromFile( const wchar_t* pFilePath, Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eÃt@C쐬܂
		//! @param[in] pFilePath ̃}eAt@C̃pX
		//! @param[in] pBuffer ̃}eAt@C
		//! @param[out] ppMaterial 쐬}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateMaterialFromMemory( const wchar_t* pFilePath, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IMaterial** ppMaterial ) = 0;

		//! @brief [Vt@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppMotion 쐬[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateMotionFromFile( const wchar_t* pFilePath, Mix::Scene::IMotion** ppMotion ) = 0;
		//! @brief [Ṽt@C쐬܂
		//! @param[in] pName O
		//! @param[in] pBuffer ̃t@C
		//! @param[out] ppMotion 쐬[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateMotionFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IMotion** ppMotion ) = 0;

		//! @brief ftHgp[eBNVXe쐬܂
		//! @param[in] bSimWorldSpace ̉]Aړ̉e󂯂Ȃꍇ True
		//! @param[in] planeType v[̎ނ\ Mix::Scene::IDefaultParticleSystem::PLANE_TYPE 񋓒萔
		//! @param[out] ppSystem 쐬p[eBNVXen Mix::Scene::IDefaultParticleSystem C^[tF[X̃|C^
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateDefaultParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IDefaultParticleSystem::PLANE_TYPE planeType, Mix::Scene::IDefaultParticleSystem** ppSystem, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief r{[hp[eBNVXe쐬܂
		//! @param[in] bSimWorldSpace ̉]Aړ̉e󂯂Ȃꍇ True
		//! @param[out] ppSystem 쐬p[eBNVXen Mix::Scene::IBillboardParticleSystem C^[tF[X̃|C^
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBillboardParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IBillboardParticleSystem** ppSystem, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief [rOp[eBN쐬܂
		//! @param[in] pMaterial [rOp[eBNŎgp}eA\ Mix::Scene::IMaterial* pMaterial C^[tF[X̃|C^
		//! @param[in] pSystem p[eBNVXe\ Mix::Scene::IParticleSystem C^[tF[X̃|C^
		//! @param[out] ppParticle 쐬[rOp[eBNn Mix::Scene::ILeavingParticle C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateLeavingParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::ILeavingParticle** ppParticle, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief XLb^[p[eBN쐬܂
		//! @param[in] pMaterial XLb^[p[eBNŎgp}eA\ Mix::Scene::IMaterial* pMaterial C^[tF[X̃|C^
		//! @param[in] pSystem p[eBNVXe\ Mix::Scene::IParticleSystem C^[tF[X̃|C^
		//! @param[out] ppParticle 쐬XLb^[p[eBNn Mix::Scene::IScatterParticle C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateScatterParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::IScatterParticle** ppParticle, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief AN^[ft@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppModel 쐬AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateActorModelFromFile( const wchar_t* pFilePath, Mix::Scene::IActorModel** ppModel ) = 0;
		//! @brief AN^[f̃t@C쐬܂
		//! @param[in] pName O
		//! @param[in] pBuffer ̃t@C\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppModel 쐬AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateActorModelFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::IActorModel** ppModel ) = 0;

		//! @brief n`ft@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppModel 쐬n`fn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateTerrainModelFromFile( const wchar_t* pFilePath, Mix::Scene::ITerrainModel** ppModel ) = 0;
		//! @brief n`f̃t@C쐬܂
		//! @param[in] pName O
		//! @param[in] pBuffer ̃t@C\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppModel 쐬n`fn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateTerrainModelFromMemory( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::Scene::ITerrainModel** ppModel ) = 0;
	};

}}
