#pragma once

//! @file Mix/Scene/IEntity.h
//! @brief GeBeBC^[tF[XCN[ht@C

#include "Mix/Scene/IRendererObject.h"

namespace Mix{ namespace Scene{

	//! @class IEntity
	//! @brief GeBeBC^[tF[X
	class IEntity : public Mix::Scene::IRendererObject
	{
	protected:
		//! @brief fXgN^
		virtual ~IEntity( void ) {}

	public:
		//! @name S
		//! @{

		//! @brief `悷邩ǂmF܂
		//! @return `悷ꍇ True Ԃ܂
		virtual Boolean IsDraw( void ) const = 0;
		//! @brief `悷邩ǂݒ肵܂
		//! @param[in] state `悷ꍇ True
		virtual void SetDraw( Boolean state ) = 0;

		//! @brief |CgCgAX|bgCgɂ郉CeBOsǂmF܂
		//! @return CeBOsꍇ True Ԃ܂
		virtual Boolean IsLocalLighting( void ) const = 0;
		//! @brief |CgCgAX|bgCgɂ郉CeBOsǂݒ肵܂
		//! @param[in] state CeBOsꍇ True
		virtual void SetLocalLighting( Boolean state ) = 0;

		//! @}

		//! @name 
		//! @{

		//! @brief |S̕`̗Dx擾܂
		//! @return DxԂ܂
		virtual UInt32 GetTransparencyPriority( void ) const = 0;
		//! @brief |S̕`̗Dxݒ肵܂
		//! @param[in] priority Dx
		//! @note Ȃ̓mdȂۂɗDx̍قOɕ`悵܂B
		virtual void SetTransparencyPriority( UInt32 priority ) = 0;

		//! @brief ǂ𔻒肷ۂ̃ftHgl擾܂
		//! @return ftHgl\ Mix::Scene::WATER_CONTAINS_RESULT
		//! @note l Mix::Scene::WCR_FRONT ɂȂ܂B
		virtual Mix::Scene::WATER_CONTAINS_RESULT GetDefaultWaterContainsResult( void ) const = 0;
		//! @brief ǂ𔻒肷ۂ̃ftHglݒ肵܂
		//! @param[in] result ftHgl\ Mix::Scene::WATER_CONTAINS_RESULT 񋓒萔
		//! @note
		//! ̐ݒ͔Ȃ̂ɑ΂ċ@\܂B<br>
		//! <br>
		//! <ul>
		//! <li>Mix::Scene::WCR_UNKNOWN</li><br>
		//! t[ɂ邩ǂ𔻒肵܂B<br>
		//! <li>Mix::Scene::WCR_FRONT</li><br>
		//! ɐʂOɂ邱ƂӖ܂B<br>
		//! <li>Mix::Scene::WCR_BACK</li><br>
		//! ɐʂ艜()ɂ邱ƂӖ܂B<br>
		//! <li>Mix::Scene::WCR_OVERLAP</li><br>
		//! ɐʂƏdȂĂ(ꕔ)ƂӖ܂B<br>
		//! </ul>
		virtual void SetDefaultWaterContainsResult( Mix::Scene::WATER_CONTAINS_RESULT result ) = 0;
	};

}}
