#pragma once

//! @file Mix/Scene/IDynamicsWorld.h
//! @brief _Ci~NX[hC^[tF[XCN[ht@C

#include "Mix/Scene/IRendererResource.h"
#include "Mix/Scene/IDynamicsObject.h"

namespace Mix{ namespace Scene{

	//! @class IDynamicsWorld
	//! @brief _Ci~NX[hC^[tF[X
	//! @note
	//! _Ci~NXIuWFNgłtAAS[XgA<br>
	//! AN^[fAeCf̃RC_[AZT[ȂǂzuA[hɂȂ܂B<br>
	//! ܂Aɑ΂ČAXB[vgpďՓ˃eXg邱Ƃł܂B
	class IDynamicsWorld : public Mix::Scene::IRendererResource
	{
	public:
		//! @struct TEST_RESULT
		//! @brief eXgʍ\
		struct TEST_RESULT
		{
			Mix::Scene::IDynamicsObject* pObject;	//!< _Ci~NXIuWFNg\ Mix::Scene::IDynamicsObject C^[tF[X̃|C^
			Mix::Dynamics::MATERIAL material;		//!< }eA\ Mix::Dynamics::MATERIAL \
			Mix::Vector3 worldPos;					//!< [hW\ Mix::Vector3 NX
			Mix::Vector3 worldNormal;				//!< [h@\ Mix::Vector3 NX
		};

		//! @class TestCallback
		//! @brief eXgR[obNNX
		class TestCallback
		{
		public:
			//! @brief fXgN^
			virtual ~TestCallback( void ) {}

		public:
			//! @brief _Ci~NXIuWFNgqbgۂɌĂяo܂
			//! @param[in] pObject qbgIuWFNg\ Mix::Scene::IDynamicsObject C^[tF[X̃|C^
			virtual Boolean OnHit( Mix::Scene::IDynamicsObject* pObject ) = 0;
		};

		//! @class TestWithoutSelfCallback
		//! @brief eXgR[obNNX(gO)
		class TestWithoutSelfCallback : public Mix::Scene::IDynamicsWorld::TestCallback
		{
		private:
			Mix::Scene::IDynamicsObject* m_pSelfObject;

		public:
			//! @brief RXgN^
			//! @param[in] pSelfObject g\ Mix::Scene::IDynamicsObject C^[tF[X̃|C^
			//! @note nIuWFNg̎QƂ͕ێ܂
			TestWithoutSelfCallback( Mix::Scene::IDynamicsObject* pSelfObject ) :
			m_pSelfObject( NULL )
			{
				MIX_ASSERT( pSelfObject != NULL );

				MIX_ADD_REF( pSelfObject );
				m_pSelfObject = pSelfObject;
			}

			//! @brief fXgN^
			virtual ~TestWithoutSelfCallback( void )
			{
				MIX_RELEASE( m_pSelfObject );
			}

			//! @brief IuWFNgqbgۂɌĂяo܂
			//! @param[in] pObject qbgIuWFNg\ Mix::Scene::IDynamicsObject C^[tF[X̃|C^
			//! @return gƂēnIuWFNgł͂Ȃꍇ True Ԃ܂
			virtual Boolean OnHit( Mix::Scene::IDynamicsObject* pObject )
			{
				return ( m_pSelfObject != pObject );
			}
		};

	protected:
		//! @brief fXgN^
		virtual ~IDynamicsWorld( void ) {}

	public:
		//! @brief d͂擾܂
		//! @return d͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetGravity( void ) const = 0;
		//! @brief d͂ݒ肵܂
		//! @param[in] gravity d͂\ Mix::Vector3 NX
		virtual void SetGravity( const Mix::Vector3& gravity ) = 0;

		//! @brief SẴIuWFNgԂɂ܂
		//! @return ԂɂłIuWFNg̐Ԃ܂
		virtual UInt32 Activate( void ) = 0;
		//! @brief SẴIuWFNg񊈓Ԃɂ܂
		//! @return 񊈓ԂɂłIuWFNg̐Ԃ܂
		virtual UInt32 Deactivate( Boolean bForce = False ) = 0;

		//! @brief ŃeXg܂
		//! @param[in] filterMask tB^[}XN\ Mix::Dynamics::OBJECT_FILTER_FLAG 񋓒萔̑gݍ킹
		//! @param[in] fromWorldPos ̊Jnʒu\ Mix::Vector3 NX
		//! @param[in] toWorldPos ̏Iʒu\ Mix::Vector3 NX
		//! @param[in] pCallback R[obN\ Mix::Scene::IDynamicsWorld::TestCallback NX̃|C^( NULLw\ )
		//! @param[out] result eXgʂ\ Mix::Scene::IDynamicsWorld::TEST_RESULT \̂̃AhX
		//! @return ƌIuWFNgꍇ True Ԃ܂
		virtual Boolean TestRay(	UInt16 filterMask,
									const Mix::Vector3& fromWorldPos,
									const Mix::Vector3& toWorldPos,
									Mix::Scene::IDynamicsWorld::TestCallback* pCallback,
									Mix::Scene::IDynamicsWorld::TEST_RESULT& result ) = 0;

		//! @brief XC[vŃeXg܂
		//! @param[in] filterMask tB^[}XN\ Mix::Dynamics::OBJECT_FILTER_FLAG 񋓒萔̑gݍ킹
		//! @param[in] pShape VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[in] fromWorldPos VFCṽXB[v̊Jnʒu\ Mix::Vector3 NX
		//! @param[in] toWorldPos VFCṽXB[v̊Jnʒu\ Mix::Vector3 NX
		//! @param[in] pCallback R[obN\ Mix::Scene::IDynamicsWorld::TestCallback NX̃|C^( NULLw\ )
		//! @param[out] result eXgʂ\ Mix::Scene::IDynamicsWorld::TEST_RESULT \̂̃AhX
		//! @return VFCvƌIuWFNgꍇ True Ԃ܂
		virtual Boolean TestSweep(	UInt16 filterMask,
									Mix::Dynamics::IShape* pShape,
									const Mix::Vector3& fromWorldPos,
									const Mix::Vector3& toWorldPos,
									Mix::Scene::IDynamicsWorld::TestCallback* pCallback,
									Mix::Scene::IDynamicsWorld::TEST_RESULT& result ) = 0;
	};

}}
