#pragma once

//! @file Mix/Scene/IDirectionalLight.h
//! @brief fBNViCgC^[tF[XCN[ht@C

#include "Mix/Scene/ILight.h"

namespace Mix{ namespace Scene{

	//! @class IDirectionalLight
	//! @brief fBNViC^[tF[X
	class IDirectionalLight : public Mix::Scene::ILight
	{
	protected:
		//! @brief fXgN^
		virtual ~IDirectionalLight( void ) {}

	public:
		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetDirection( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param dir \ Mix::Vector3 NX
		virtual void SetDirection( const Mix::Vector3& dir ) = 0;

		//! @brief F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetColor( void ) const = 0;
		//! @brief Fݒ肵܂
		//! @param[in] color F\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& color ) = 0;

		//! @brief fobO : `悷郉C̒擾܂
		//! @return Ԃ܂
		virtual Float32 Debug_GetDrawLength( void ) const = 0;
		//! @brief fobO : `悷郉C̒ݒ肵܂
		//! @param[in] len 
		virtual void Debug_SetDrawLength( Float32 len ) = 0;
	};

}}
