#pragma once

//! @file Mix/Scene/IDefaultParticleSystem.h"
//! @brief ftHgp[eBNvf[T[C^[tF[XCN[ht@C

#include "Mix/Scene/ISimpleParticleSystem.h"

namespace Mix{ namespace Scene{

	//! @class IDefaultParticleSystem
	//! @brief ftHgp[eBNvf[T[C^[tF[X
	//! @note
	//! CeBO\ȃp[eBN𐶐A܂B<br>
	//! ܂CeBOɕKvȖ@ɑAڐA]@LłAov}bsOł܂B
	class IDefaultParticleSystem : public Mix::Scene::ISimpleParticleSystem
	{
	public:
		//! @enum PLANE_TYPE
		//! @brief v[^Cv񋓒萔
		enum PLANE_TYPE
		{
			P_XY = 0,	//!< XY
			P_XZ = 1,	//!< XZ
			P_YZ = 2,	//!< YZ
		};

	protected:
		//! @brief fXgN^
		virtual ~IDefaultParticleSystem( void ) {}

	public:
		//! @brief ]̍ŏ͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMinAngularImpulse( void ) const = 0;
		//! @brief ]̍ő匂͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMaxAngularImpulse( void ) const = 0;
		//! @brief ]̌͂ݒ肵܂
		//! @param[in] minImpulse ŏ͂\ Mix::Vector3 NX
		//! @param[in] maxImpulse ő匂͂\ Mix::Vector3 NX
		virtual void SetAngularImpulse( const Mix::Vector3& minImpulse, const Mix::Vector3& maxImpulse ) = 0;

		//! @brief ]̍ŏx擾܂
		//! @return x\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMinAngularAcceleration( void ) const = 0;
		//! @brief ]̍őx擾܂
		//! @return x\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMaxAngularAcceleration( void ) const = 0;
		//! @brief ]̉xݒ肵܂
		//! @param[in] minAcc ŏx\ Mix::Vector3 NX
		//! @param[in] maxAcc őx\ Mix::Vector3 NX
		virtual void SetAngularAcceleration( const Mix::Vector3& minAcc, const Mix::Vector3& maxAcc ) = 0;

		//! @brief v[̎ނ擾܂
		//! @return ނ\ Mix::Scene::IDefaultParticleSystem::PLANE_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultParticleSystem::PLANE_TYPE GetPlaneType( void ) const = 0;
	};

}}
