#pragma once

//! @file Mix/Scene/IActorModel.h
//! @brief AN^[fC^[tF[XCN[ht@C

#include "Mix/Scene/IModel.h"
#include "Mix/Geometry/Sphere.h"

namespace Mix{ namespace Scene{

	//! @class IActorModel
	//! @brief AN^[fC^[tF[X
	class IActorModel : public Mix::Scene::IModel
	{
	public:
		//! @enum RESET_FLAGS
		//! @brief ZbgtO񋓒萔
		enum RESET_FLAGS
		{
			//! @brief [Js( p )
			//! @note
			//! ̃tOݒ肢ȂԂŃ[VĐĂꍇ́A<br>
			//! gWVLZAJgt[̃[Jsݒ肵܂B<br>
			R_INIT_LOCAL_MATRIX		= 0x00000001,

			//! @brief [hsXV
			R_UPDATE_WORLD_MATRIX	= 0x00000002,

			//! @brief SăZbgtO
			R_ALL					= ( R_INIT_LOCAL_MATRIX | R_UPDATE_WORLD_MATRIX ),
		};

		//! @enum CLONE_FLAGS
		//! @brief N[tO񋓒萔
		enum CLONE_FLAGS
		{
			C_SHARED_MATERIAL			= 0x00000001,	//!< }eAL
			C_SHARED_MOTION				= 0x00000002,	//!< [VL
			C_DUPLICATE_MOTION_ENTRIES	= 0x00000004,	//!< [VGg[𕡐

			C_ALL						= ( C_SHARED_MATERIAL | C_SHARED_MOTION | C_DUPLICATE_MOTION_ENTRIES ),	//!< S
		};

		//! @enum BEHAVIOR_FLAGS
		//! @brief U镑tO񋓒萔
		enum BEHAVIOR_FLAGS
		{
			//! @brief ȏ( IsValid() == False )̏ꍇ̓[g[V݂̂ɂ
			B_INVALID_ONLY_ROOT_MOTION		= 0x00000001,

			//! @brief Ɣf( CONFIG::farMinDist CONFIG::farMaxDist )ꂽꍇ́Aw肳ꂽl( skipFrames )[Ṽt[XLbv
			B_FAR_SKIP_MOTION_FRAME			= 0x00000002,

			//!< @brief EɓĂȂꍇ( IsViewVisible() == False )́Aw肳ꂽl( skipFrames )[Ṽt[XLbv
			B_INVISIBLE_SKIP_MOTION_FRAME	= 0x00000004,

			//! @brief SẴtO
			B_ALL_FLAGS						=	B_INVALID_ONLY_ROOT_MOTION |
												B_FAR_SKIP_MOTION_FRAME |
												B_INVISIBLE_SKIP_MOTION_FRAME,
		};

		//! @struct CONFIG
		//! @brief ݒ\
		struct CONFIG
		{
			//! @brief Mix::Scene::IActorModel::BEHAVIOR_FLAGS 񋓒萔̑gݍ킹
			UInt32 behaviorFlags;

			//! @brief Ɣfŏ( farMinDist > farMaxDist )
			//! @note ̒l Mix::Scene::IActorModel::IsFar Mix::Scene::IActorModel::GetFarRatio ŕԂlɂgp܂B
			Float32 farMinDist;
			//! @brief Ɣfő勗( farMinDist < farMaxDist )
			//! @note ̒l Mix::Scene::IActorModel::IsFar Mix::Scene::IActorModel::GetFarRatio ŕԂlɂgp܂B
			Float32 farMaxDist;

			//! @brief XLbvőt[( FAR_SKIP_MOTION_FRAME INVISIBLE_SKIP_MOTION_FRAME )
			//! @note ̒l̓[Vɑ΂čp܂B
			UInt32 maxSkipFrames;
		};

		//! @struct STATE
		//! @brief Xe[g\
		struct STATE
		{
			Float32 deltaTimer;			//!< XLbvt[̃f^^C̍v

			Float32 farRatio;			//!< ( CONFIG::farMinDist(0.0f) ` CONFIG::farMaxDist(1.0f) )

			UInt32 skipFrames;			//!< XLbvt[
			UInt32 curMaxSkipFrames;	//!< ݂̃XLbvőt[
		};

	protected:
		//! @brief fXgN^
		virtual ~IActorModel( void ){}

	public:
		//! @name S
		//! @{

		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::IActorModel::CONFIG \̂Ԃ܂
		virtual const Mix::Scene::IActorModel::CONFIG& GetConfig( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] config ݒ\ Mix::Scene::IActorModel::CONFIG \
		virtual void SetConfig( const Mix::Scene::IActorModel::CONFIG& config ) = 0;

		//! @brief Xi[擾܂
		//! @param[in] ppListener 擾Xi[\ Mix::Scene::IActorListener C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾Xi[͎QƃJE^ +1 ܂B
		virtual Boolean GetListener( Mix::Scene::IActorListener** ppListener ) = 0;
		//! @brief Xi[ݒ肵܂
		//! @param[in] pListener ݒ肷郊Xi[\ Mix::Scene::IActorListener C^[tF[X̃|C^( NULLw\ )
		//! @note ꍇ́AÕXi[̎QƃJE^ -1 AVK̃Xi[̎QƃJE^ +1 ܂B<br>
		virtual void SetListener( Mix::Scene::IActorListener* pListener ) = 0;

		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		//! @note
		//! Őݒ肳ꂽ[hs͍XV( Update )Ŕf܂B<br>
		//! AL Ll}eBbNLN^[ RC_[(ftHg) ݂Ăꍇ́A<br>
		//! ɂă[hs̍XVs邽߁Af܂B<br>
		//! Iɔfꍇ́AReset gpĂB
		virtual void SetWorldMatrix( const Mix::Matrix4x4& worldMat ) = 0;

		//! @brief m[h̐擾܂
		//! @return m[h̐Ԃ܂
		virtual UInt32 GetNodeCount( void ) const = 0;
		//! @brief m[h̃CfbNX擾܂
		//! @param[in] pName m[h̖O
		//! @return ꍇ m[h̃CfbNXԂ܂B<br>
		//! sꍇ 0xFFFFFFFF Ԃ܂
		virtual UInt32 GetNodeIndex( const wchar_t* pName ) const = 0;
		//! @brief m[h擾܂
		//! @param[in] index m[h̃CfbNX( 0 ̓[gm[hӖ܂ )
		//! @param[out] ppNode 擾m[hn Mix::Scene::IActorNode C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ m[h̎QƃJE^ +1 ܂
		virtual Boolean GetNodeByIndex( UInt32 index, Mix::Scene::IActorNode** ppNode ) = 0;
		//! @brief m[h擾܂
		//! @param[in] pName m[h̖O
		//! @param[out] ppNode 擾m[hn Mix::Scene::IActorNode C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ m[h̎QƃJE^ +1 ܂
		virtual Boolean GetNodeByName( const wchar_t* pName, Mix::Scene::IActorNode** ppNode ) = 0;

		//! @brief [V~LT[擾܂
		//! @param[out] ppMotionMixer 擾[V~LT[n Mix::Scene::IMotionMixer C^[tF[X̃|C^̃AhX
		//! @note 擾[V~LT[͎QƃJE^ +1 ܂
		virtual void GetMotionMixer( Mix::Scene::IMotionMixer** ppMotionMixer ) = 0;

		//! @brief Zbg܂
		//! @param[in] flags ZbgtO\ Mix::Scene::IActorModel::RESET_FLAGS 񋓒萔̑gݍ킹
		//! @note [hɔzuۂȂǂɂgB
		virtual void Reset( UInt32 flags = Mix::Scene::IActorModel::R_UPDATE_WORLD_MATRIX ) = 0;

		//! @brief XV܂
		//! @note
		//! ÓIȃAN^[f̏ꍇɎgp܂B<br>
		//! <br>
		//! ̒iKł́A<br>
		//! ZT[ ̃[hgXtH[A<br>
		//! Ll}eBbNLN^[ ̈ړx̍XV͍s܂A<br>
		//! f m[h RXgCg ̃[hs͍XV܂B<br>
		//! <br>
		//! ܂Ã\bh̓_Ci~NX̍XVOɎsKv܂B
		virtual void Update( void ) = 0;
		//! @brief XV܂
		//! @param[in] dt 1t[XV̂ɂ鎞( Mix::IEngine::GetDT Ŏ擾ł܂ )
		//! @note
		//! IȃAN^[f̏ꍇɎgp܂B<br>
		//! <br>
		//! ̒iKł́A<br>
		//! m[h ̃[JsA<br>
		//! ZT[ ̃[hgXtH[A<br>
		//! Ll}eBbNLN^[ ̈ړx̍XV͍s܂A<br>
		//! f m[h RXgCg ̃[hs͍XV܂B<br>
		//! <br>
		//! ܂Ã\bh̓_Ci~NX̍XVOɎsKv܂B
		virtual void Update( Float32 dt ) = 0;

		//! @brief ]x擾܂
		//! @return ]x\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetAngularVelocity( void ) const = 0;
		//! @brief ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLinearVelocity( void ) const = 0;

		//! @brief tbV܂
		//! @note
		//! f m[h RXgCg ̃[hsXV܂B<br>
		//! <br>
		//! ܂Ã\bh̓_Ci~NX̍XVɎsKv܂B
		virtual void Refresh( void ) = 0;

		//! @brief Xe[g擾܂
		//! @return Xe[g\ Mix::Scene::IActorModel::STATE \̂Ԃ܂
		virtual const Mix::Scene::IActorModel::STATE& GetState( void ) const = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::Sphere NXԂ܂
		//! @note ÉAtbV( Refresh )ōXV܂B
		virtual const Mix::Geometry::Sphere& GetBounds( void ) const = 0;

		//! @brief EɓĂ邩ǂmF܂
		//! @return EɓĂꍇ True Ԃ܂
		virtual Boolean IsVisible( void ) const = 0;
		//! @brief EɓĂ邩ǂmF܂
		//! @param[in] id r[̎ʎq
		//! @return EɓĂꍇ True Ԃ܂
		virtual Boolean IsVisible( UInt32 id ) const = 0;
		//! @brief LɂȂĂ邩ǂmF܂
		//! @return LɂȂĂꍇ True Ԃ܂
		//! @note LȏԂƂ́AEɓĂAeƂēeĂԂ̂Ƃ\܂B
		virtual Boolean IsValid( void ) const = 0;
		//! @brief LɂȂĂ邩ǂmF܂
		//! @param[in] id r[̎ʎq
		//! @return LɂȂĂꍇ True Ԃ܂
		virtual Boolean IsValid( UInt32 id ) const = 0;
		//! @brief OǂmF܂
		//! @return Ȍꍇ True Ԃ܂
		//! @note OƂ͕`攻Ɏgp锪؂͈̔͂𒴂ĔzuĂԂ̂Ƃ\܂B
		virtual Boolean IsIgnored( void ) const = 0;

		//! @brief g̃N[쐬܂
		//! @param[out] ppActorModel g̃N[n Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @param[in] flags N[̃tO\ Mix::Scene::IActorModel::CLONE_FLAGS 񋓒萔̑gݍ킹
		//! @return ꍇ True Ԃ܂
		virtual Boolean Clone( Mix::Scene::IActorModel** ppActorModel, UInt32 flags = Mix::Scene::IActorModel::C_ALL ) = 0;

		//! @}

		//! @name _Ci~NX
		//! @{

		//! @brief Ll}eBbNLN^[݂邩ǂmF܂
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ExistsKinematicCharacter( void ) const = 0;
		//! @brief Ll}eBbNLN^[擾܂
		//! @param[out] ppKinematicCharacter 擾Ll}eBbNLN^[n Mix::Scene::IActorKinematicCharacter C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾Ll}eBbNLN^[͎QƃJE^ +1 ܂
		virtual Boolean GetKinematicCharacter( Mix::Scene::IActorKinematicCharacter** ppKinematicCharacter ) = 0;

		//! @brief RC_[݂邩ǂmF܂
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ExistsCollider( void ) const = 0;
		//! @brief RC_[擾܂
		//! @param[out] ppCollider 擾RC_[n Mix::Scene::IActorCollider C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾RC_[͎QƃJE^ +1 ܂
		virtual Boolean GetCollider( Mix::Scene::IActorCollider** ppCollider ) = 0;

		//! @brief ZT[̐擾܂
		//! @return ZT[̐Ԃ܂
		virtual UInt32 GetSensorCount( void ) const = 0;
		//! @brief ZT[擾܂
		//! @param[in] index 擾ZT[̃CfbNX
		//! @param[out] ppSensor 擾ZT[n Mix::Scene::ISensor C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾ZT[͎QƃJE^ +1 ܂
		virtual Boolean GetSensor( UInt32 index, Mix::Scene::ISensor** ppSensor ) = 0;

		//! @brief _Ci~NXfBN^[擾܂
		//! @param[out] ppDynamicsDirector _Ci~NXfBN^[\ Mix::Scene::IActorDynamicsDirector C^[tF[X̃|C^
		//! @note 擾_Ci~NXfBN^[͎QƃJE^ +1 ܂
		virtual void GetDynamicsDirector( Mix::Scene::IActorDynamicsDirector** ppDynamicsDirector ) = 0;

		//! @}

		//! @name fobO
		//! @{

		//! @brief fobO : `悷ۂ̃XP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 Debug_GetDrawAxisScaling( void ) const = 0;
		//! @brief fobO : `悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling XP[
		virtual void Debug_SetDrawAxisScaling( Float32 scaling ) = 0;

		//! @brief fobO : WCg̃t[`悷ۂ̍ŏTCY擾܂
		//! @return ŏTCYԂ܂
		virtual Float32 Debug_GetDrawJointFrameMinSize( void ) const = 0;
		//! @brief fobO : WCg̃t[`悷ۂ̍ŏTCYݒ肵܂
		//! @param[in] minSize ŏTCY
		virtual void Debug_SetDrawJointFrameMinSize( Float32 minSize ) = 0;

		//! @brief fobO : WCg̃~bg`悷ۂ̃XP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 Debug_GetDrawJointLimitScaling( void ) const = 0;
		//! @brief fobO : WCg̃~bg`悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling XP[
		virtual void Debug_SetDrawJointLimitScaling( Float32 scaling ) = 0;

		//! @}
	};

}}
