#pragma once

//! @file Mix/Scene/IActorKinematicCharacter.h
//! @brief AN^[Ll}eBbNLN^[C^[tF[XCN[ht@C

#include "Mix/Scene/IKinematicCharacter.h"

namespace Mix{ namespace Scene{

	//! @class IActorKinematicCharacter
	//! @brief AN^[Ll}eBbNLN^[
	class IActorKinematicCharacter : public Mix::Scene::IKinematicCharacter
	{
	protected:
		//! @brief fXgN^
		virtual ~IActorKinematicCharacter( void ) {}

	public:
		//! @brief ݂̃tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetCurrentFilterGroup( void ) const = 0;
		//! @brief tB^[O[v擾܂
		//! @param[in] mode 擾郂[h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔( DKC_DISABLE ȊO )
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( Mix::Scene::DYNAMICS_KCHAR_MODE mode ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] mode ݒ肷郂[h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔( DKC_DISABLE ȊO )
		//! @param[in] filterGroup tB^[O[v
		//! @note l ( Mix::Dynamics::OF_CHARACTER ) ɂȂ܂B
		virtual void SetFilterGroup( Mix::Scene::DYNAMICS_KCHAR_MODE mode, UInt16 filterGroup ) = 0;

		//! @brief ݂̃tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetCurrentFilterMask( void ) const = 0;
		//! @brief tB^[}XN擾܂
		//! @param[in] mode 擾郂[h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔( DKC_DISABLE ȊO )
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( Mix::Scene::DYNAMICS_KCHAR_MODE mode ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] mode ݒ肷郂[h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔( DKC_DISABLE ȊO )
		//! @param[in] filterMask tB^[}XN
		//! @note l ( Mix::Dynamics::OF_STATIC | Mix::Dynamics::OF_CHARACTER ) ɂȂ܂B
		virtual void SetFilterMask( Mix::Scene::DYNAMICS_KCHAR_MODE mode, UInt16 filterMask ) = 0;

		//! @brief ]x擾܂
		//! @return ]x\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetAngularVelocity( void ) const = 0;
		//! @brief ]xݒ肵܂
		//! @param[in] vel ]x\ Mix::Quaternion NX
		virtual void SetAngularVelocity( const Mix::Quaternion& vel ) = 0;

		//! @brief ĂƔf鑬x擾܂
		//! @return xԂ܂
		virtual Float32 GetActiveThreshold( void ) const = 0;
		//! @brief ĂƔf鑬xݒ肵܂
		//! @param[in] threshold x( 0.0f ȏ )
		virtual void SetActiveThreshold( Float32 threshold ) = 0;
		//! @brief 񊈓ԂƔfoߎԂ擾܂
		//! @return oߎԂԂ܂
		virtual Float32 GetDeactivationElapsedTime( void ) const = 0;
		//! @brief 񊈓ԂƔfoߎԂݒ肵܂
		//! @param[in] elapsedTime oߎ( 0.0fȏ )
		virtual void SetDeactivationElapsedTime( Float32 elapsedTime ) = 0;

		//! @brief Ă邩ǂmF܂
		//! @return Ăꍇ True Ԃ܂
		virtual Boolean IsActive( void ) const = 0;

		//! @brief ܂
		//! @param[in] upAxisIndex Ll}eBbNLN^[̏̎̃CfbNX( X:0 Y:1 Z:2 )
		//! @param[in] worldUp [h̏\ Mix::Vector3 NX
		virtual void Stand( UInt32 upAxisIndex = 1, const Mix::Vector3& worldUp = Mix::Vector3( 0.0f, 1.0f, 0.0f ) ) = 0;
	};

}}
