#pragma once

//! @file Mix/Scene/IActorDynamicsDirector.h
//! @brief AN^[_Ci~NXfBN^[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IActorDynamicsDirector
	//! @brief AN^[_Ci~NXfBN^[C^[tF[X
	class IActorDynamicsDirector : public Mix::Reference
	{
	public:
		//! @class ICollection
		//! @brief RNVC^[tF[X
		//! @tparam T IuWFNǧ^
		template<typename T>
		class ICollection : public Mix::Reference
		{
		protected:
			//! @brief fXgN^
			virtual ~ICollection( void ) {}

		public:
			//! @brief IuWFNg̐擾܂
			//! @return IuWFNg̐Ԃ܂
			virtual UInt32 GetCount( void ) const = 0;

			//! @brief IuWFNg擾܂
			//! @param[in] index CfbNX
			//! @param[out] ppObject 擾IuWFNg̃|C^̃AhXԂ܂
			//! @return ꍇ True Ԃ܂
			//! @note 擾IuWFNg͎QƃJE^ +1 ܂
			virtual Boolean Get( UInt32 index, T** ppObject ) = 0;

			//! @brief IuWFNg擾܂
			//! @param[in] index CfbNX
			//! @return ꍇ̓IuWFNg̃|C^Ԃ܂B<br>
			//! ܂sꍇ NULL Ԃ܂B
			//! @note IuWFNg̃|C^ԂŁAQƃJE^̓CNg܂̂ŒӂĂB
			virtual T* operator[] ( UInt32 index ) const = 0;
		};

	protected:
		//! @brief fXgN^
		virtual ~IActorDynamicsDirector( void ) {}

	public:
		//! @brief LN^[LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsCharacterEnabled( void ) const = 0;
		//! @brief LN^[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetCharacterEnabled( Boolean state ) = 0;
		//! @brief LN^[̃[h擾܂
		//! @return [h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔Ԃ܂
		virtual Mix::Scene::DYNAMICS_KCHAR_MODE GetCharacterMode( void ) const = 0;
		//! @brief LN^[̃[hݒ肵܂
		//! @param[in] mode [h\ Mix::Scene::DYNAMICS_KCHAR_MODE 񋓒萔
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note ʏ킱̑ Mix::Scene::IActorModel::Update ōs܂B
		virtual void SetCharacterMode( Mix::Scene::DYNAMICS_KCHAR_MODE mode, Boolean bInstantly = False ) = 0;

		//! @brief RC_[LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsColliderEnabled( void ) const = 0;
		//! @brief RC_[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetColliderEnabled( Boolean state ) = 0;
		//! @brief RC_[̃[h擾܂
		//! @return [h\ Mix::Scene::DYNAMICS_COLLIDER_MODE 񋓒萔Ԃ܂
		virtual Mix::Scene::DYNAMICS_COLLIDER_MODE GetColliderMode( void ) const = 0;
		//! @brief RC_[̃[hݒ肵܂
		//! @param[in] mode [h\ Mix::Scene::DYNAMICS_COLLIDER_MODE 񋓒萔
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note
		//! ʏ킱̑ Mix::Scene::IActorModel::Update ōs܂B<br>
		//! <br>
		//! <b>(m̃oO)</b><br>
		//! [hOh[( Mix::Scene::DC_RAGDOLL )ɐݒ肵ꍇA<br>
		//! fٗlȕό`Ă܂ꍇ́A Mix::Scene::IActorModel::Reset ȂǂgpāAm[h̃[JslɂĂB<br>
		//! ̓m[hɃRC_[݂A[VȂǂɂ胍[Js񂪕ύXĂۂɔ܂B<br>
		//! <br>
		virtual void SetColliderMode( Mix::Scene::DYNAMICS_COLLIDER_MODE mode, Boolean bInstantly = False ) = 0;

		//! @brief ZT[Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsSensorEnabled( void ) const = 0;
		//! @brief ZT[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetSensorEnabled( Boolean state ) = 0;

		//! @brief SẴRC_[܂ރRNV擾܂
		//! @param[out] ppCollection RNV\ Mix::Scene::IActorDynamicsController::ICollection<Mix::Scene::IActorCollider> C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetColliders( Mix::Scene::IActorDynamicsDirector::ICollection<Mix::Scene::IActorCollider>** ppCollection ) = 0;
		//! @brief w肵ÕRC_[܂ރRNV擾܂
		//! @param[in] pName O
		//! @param[out] ppCollection RNV\ Mix::Scene::IActorDynamicsController::ICollection<Mix::Scene::IActorCollider> C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetColliders( const wchar_t* pName, Mix::Scene::IActorDynamicsDirector::ICollection<Mix::Scene::IActorCollider>** ppCollection ) = 0;

		//! @brief SẴZT[܂ރRNV擾܂
		//! @param[out] ppCollection RNV\ Mix::Scene::IActorDynamicsController::ICollection<Mix::Scene::ISensor> C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetSensors( Mix::Scene::IActorDynamicsDirector::ICollection<Mix::Scene::ISensor>** ppCollection ) = 0;
		//! @brief w肵ÕZT[܂ރRNV擾܂
		//! @param[in] pName O
		//! @param[out] ppCollection RNV\ Mix::Scene::IActorDynamicsController::ICollection<Mix::Scene::ISensor> C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetSensors( const wchar_t* pName, Mix::Scene::IActorDynamicsDirector::ICollection<Mix::Scene::ISensor>** ppCollection ) = 0;

		//! @brief ԂǂmF܂
		//! @return Ԃ̏ꍇ True Ԃ܂
		//! @note Ԃl Mix::Scene::IActorModel::Refresh ōXV܂B
		virtual Boolean IsActive( void ) const = 0;
		//! @brief Ԃɂ܂
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note ʏ킱̑ Mix::Scene::IActorModel::Update ōs܂B
		virtual void Activate( Boolean bInstantly = False ) = 0;
		//! @brief 񊈓Ԃɂ܂
		//! @param[in] bForce Iɔ񊈓Ԃɂꍇ True
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note ʏ킱̑ Mix::Scene::IActorModel::Update ōs܂B
		virtual void Deactivate( Boolean bForce = False, Boolean bInstantly = False ) = 0;

		//! @brief tH[XNA܂
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note ʏ킱̑ Mix::Scene::IActorModel::Refresh ōs܂B
		virtual void ClearForce( Boolean bInstantly = False ) = 0;
		//! @brief [VNA܂
		//! @param[in] bInstantly Ɏsꍇ True
		//! @note
		//! utH[XvuxvNA܂B
		//! ʏ킱̑ Mix::Scene::IActorModel::Refresh ōs܂B
		virtual void ClearMotion( Boolean bInstantly = False ) = 0;

		//! @brief ړ~鑬x擾܂
		//! @return ړ~鑬xԂ܂
		virtual Float32 GetLinearSleepingThresholds( void ) const = 0;
		//! @brief ړ~鑬xݒ肵܂
		//! @param[in] threshold ړ~鑬x
		virtual void SetLinearSleepingThresholds( Float32 threshold ) = 0;

		//! @brief ]~鑬x擾܂
		//! @return ]~鑬xԂ܂
		virtual Float32 GetAngularSleepingThresholds( void ) const = 0;
		//! @brief ]~鑬xݒ肵܂
		//! @param[in] threshold ]~鑬x
		virtual void SetAngularSleepingThresholds( Float32 threshold ) = 0;
	};

}}
