#pragma once

//! @file Mix/Scene/IActorCollider.h"
//! @brief AN^[RC_[C^[tF[XCN[ht@C

#include "Mix/Scene/ICollider.h"
#include "Mix/Dynamics/IRigidBody.h"

namespace Mix{ namespace Scene{

	//! @class IActorCollider
	//! @brief AN^[RC_[C^[tF[X
	class IActorCollider : public Mix::Scene::ICollider
	{
	protected:
		//! @brief fXgN^
		virtual ~IActorCollider( void ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief ݂̃tB^[O[v擾܂
		//! @return ݂̃tB^[O[vԂ܂
		virtual UInt16 GetCurrentFilterGroup( void ) const = 0;
		//! @brief tB^[O[v擾܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( Mix::Dynamics::IRigidBody::STATUS status ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @param[in] value tB^[O[v
		//! @note
		//! l̓RC_[ŎgpĂ郊Wbh{fB̃Xe[^XɂĈقȂ܂B<br>
		//! <pre>
		//! DEFAULT   : Mix::Dynamics::OF_DEFAULT
		//! STATIC    : Mix::Dynamics::OF_STATIC
		//! KINEMATIC : Mix::Dynamics::OF_KINEMATIC
		//! </pre>
		virtual void SetFilterGroup( Mix::Dynamics::IRigidBody::STATUS status, UInt16 value ) = 0;

		//! @brief ݂̃tB^[}XN擾܂
		//! @return ݂̃tB^[}XNԂ܂
		virtual UInt16 GetCurrentFilterMask( void ) const = 0;
		//! @brief tB^[}XN擾܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( Mix::Dynamics::IRigidBody::STATUS status ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @param[in] value tB^[}XN
		//! @note
		//! l̓RC_[ŎgpĂ郊Wbh{fB̃Xe[^XɂĈقȂ܂B<br>
		//! <pre>
		//! DEFAULT :   Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_STATIC |
		//!             Mix::Dynamics::OF_KINEMATIC |
		//!             Mix::Dynamics::OF_SENSOR</pre>
		//! <pre>
		//! STATIC :    Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_KINEMATIC |
		//!             Mix::Dynamics::OF_SENSOR |
		//!             Mix::Dynamics::OF_CHARACTER |
		//!             Mix::Dynamics::OF_DEBRIS</pre>
		//! <pre>
		//! KINEMATIC : Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_SENSOR</pre>
		virtual void SetFilterMask( Mix::Dynamics::IRigidBody::STATUS status, UInt16 value ) = 0;

		//! @brief }eA擾܂
		//! @return }eA\ Mix::Dynamics::MATERIAL \̂Ԃ܂
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] material ݒ肷}eA\ Mix::Dynamics::MATERIAL \
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material ) = 0;

		//! @brief Ԃ擾܂
		//! @return Ԃ̏ꍇ True Ԃ܂
		virtual Boolean IsActive( void ) const = 0;
		//! @brief Ԃɂ܂
		//! @return ꍇ True Ԃ܂
		//! @note Xe[^XuX^eBbNv̏ꍇÃ\bh False Ԃ܂
		virtual Boolean Activate( void ) = 0;
		//! @brief 񊈓Ԃɂ܂
		//! @param[in] bFroce Iɔ񊈓Ԃɂꍇ True
		//! @return ꍇ True Ԃ܂
		//! @note Xe[^XuX^eBbNvuLl}eBbNv̏ꍇÃ\bh False Ԃ܂
		virtual Boolean Deactivate( Boolean bFroce = False ) = 0;

		//! @brief ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetLinearVelocity( void ) = 0;
		//! @brief ړxݒ肵܂
		//! @param[in] velocity `x\ Mix::Vector3 NX
		virtual void SetLinearVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief ]x擾܂
		//! @return ]x\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetAngularVelocity( void ) = 0;
		//! @brief ]xݒ肵܂
		//! @param[in] velocity ]x\ Mix::Vector3 NX
		virtual void SetAngularVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief ړɌ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		virtual void ApplyLinearImpulse( const Mix::Vector3& impulse ) = 0;
		//! @brief ]Ɍ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		virtual void ApplyAngularImpulse( const Mix::Vector3& impulse ) = 0;
		//! @brief w肵ʒuɌ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		//! @param[in] pos ͂Kp鑊Έʒu\ Mix::Vector3 NX
		virtual void ApplyImpulse( const Mix::Vector3& impulse, const Mix::Vector3& pos ) = 0;

		//! @brief ړɓKpĂ͂擾܂
		//! @return KpĂ͂\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetTotalLinearForce( void ) = 0;
		//! @brief ]ɓKpĂ͂擾܂
		//! @return KpĂ͂\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetTotalAngularForce( void ) = 0;
		//! @brief ړɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		virtual void ApplyLinearForce( const Mix::Vector3& force ) = 0;
		//! @brief ]ɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		virtual void ApplyAngularForce( const Mix::Vector3& force ) = 0;
		//! @brief w肵ʒuɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		//! @param[in] pos ͂Kp鑊Έʒu\ Mix::Vector3 NX
		virtual void ApplyForce( const Mix::Vector3& force, const Mix::Vector3& pos ) = 0;

		//! @brief tH[XNA܂
		virtual void ClearForce( void ) = 0;
		//! @brief [VNA܂
		virtual void ClearMotion( void ) = 0;
	};

}}
