#pragma once

//! @file Mix/Reference.h
//! @brief t@XNXCN[ht@C

#include "Mix/AtomicValue.h"

namespace Mix{

	//! @class Reference
	//! @brief t@XNX
	class _MIX_DLL_API Reference
	{
	private:
		Mix::AtomicValue m_Count;	

	protected:
		//! @brief RXgN^
		Reference( void )
		{
			m_Count.Set( 1 );
		}

		//! @brief RXgN^
		//! @param count JE^
		Reference( Int32 count )
		{
			m_Count.Set( count );
		}

		//! @brief fXgN^
		virtual ~Reference( void )
		{
		}

	public:
		//! @brief QƃJE^1₷
		//! @return QƃJE^
		Int32 AddRef( void )
		{
			return m_Count.Increment();
		}

		//! @brief QƃJE^1炷
		//! @return QƃJE^
		Int32 Release( void )
		{
			Int32 count = m_Count.Decrement();
			if( count == 0 )
			{
				delete this;
			}

			return count;
		}

		//! @brief QƃJE^擾܂
		//! @return QƃJE^
		Int32 GetRefCount( void )
		{
			return m_Count.Get();
		}
	};

};
