#pragma once

//! @file Mix/Point.h
//! @brief |CgNXCN[ht@C

namespace Mix
{
	class Vector2;

	//! @class Point
	//! @brief |CgNX
	class _MIX_DLL_API Point
	{
	public:
		union
		{
			struct
			{
				Int32 x;	//!< X
				Int32 y;	//!< Y
			};

			Int32 data[2];	//!< f[^
		};

	public:
		//! @brief RXgN^
		Point( void );
		//! @brief RXgN^
		//! @param[in] px XW
		//! @param[in] py YW
		Point( Int32 px, Int32 py );
		//! @brief Rs[RXgN^
		//! @param[in] pp Rs[|Cg
		Point( const Point& pp );
		//! @brief Rs[RXgN^
		//! @param[in] pp Rs[|Cg
		Point( const Vector2& pp );

	public:
		//! @brief r
		//! @param[in] pp r|Cg
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Point& pp ) const;
		//! @brief r
		//! @param[in] pp r|Cg
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Point& pp ) const;

		//! @brief 
		//! @param[in] pp l
		//! @return 
		Point& operator = ( const Point& pp );
		//! @brief 
		//! @param[in] pp l
		//! @return 
		Point& operator = ( const Vector2& pp );
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point& operator += ( const Point& pp );
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point& operator -= ( const Point& pp );
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point& operator *= ( const Point& pp );
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point& operator /= ( const Point& pp );

		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point operator + ( const Point& pp ) const;
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point operator - ( const Point& pp ) const;
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point operator * ( const Point& pp ) const;
		//! @brief Z
		//! @param[in] pp Zl
		//! @return 
		Point operator / ( const Point& pp ) const;

		//! @brief 𔽓]܂
		//! @return 
		Point operator -( void ) const;

		//! @brief Z
		//! @param[in] s Zl
		//! @return 
		Point& operator *= ( Int32 s );
		//! @brief Z
		//! @param[in] s Zl
		//! @return 
		Point& operator /= ( Int32 s );

		//! @brief Z
		//! @param[in] s Zl
		//! @return 
		Point operator * ( Int32 s ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return 
		Point operator / ( Int32 s ) const;

		//! @brief |Cgݒ肵܂
		//! @param[in] px XW
		//! @param[in] py YW
		void Set( Int32 px, Int32 py );

		//! @brief ̃|Cg̍ŏl擾܂
		//! @param[in] p0 rl\ Mix::Point NX
		//! @param[in] p1 rl\ Mix::Point NX
		//! @return |Cg̍ŏl\ Mix::Point NXԂ܂
		static Point Min( const Point& p0, const Point& p1 );

		//! @brief ̃|Cg̍ől擾܂
		//! @param[in] p0 rl\ Mix::Point NX
		//! @param[in] p1 rl\ Mix::Point NX
		//! @return |Cg̍ől\ Mix::Point NXԂ܂
		static Point Max( const Point& p0, const Point& p1 );

	public:
		//! @brief l( 0, 0 )擾܂
		//! @return l\ Mix::Point NXԂ܂
		static const Mix::Point& Zero( void )
		{
			static const Mix::Point zero( 0, 0 );

			return zero;
		}
	};
};
