#pragma once

//! @file Mix/Network/ITcpServerCallback.h
//! @brief TCPT[o[R[obNC^[tF[XCN[ht@C

namespace Mix{ namespace Network{

	//! @class ITcpServerCallback
	//! @brief TCPT[o[R[obNC^[tF[X
	class ITcpServerCallback
	{
	public:
		//! @brief ZbVJnۂɌĂяo܂
		//! @param[in] pSession Mix::Network::ISession C^[tF[X̃|C^
		//! @param[in] pPacketSender Mix::Network::IPacketSender C^[tF[X̃|C^
		virtual void OnOpenSession( Mix::Network::ISession* pSession, Mix::Network::IPacketSender* pPacketSender ) = 0;
		//! @brief ZbVIۂɌĂяo܂
		//! @param[in] pSession Mix::Network::ISession C^[tF[X̃|C^
		virtual void OnCloseSession( Mix::Network::ISession* pSession ) = 0;

		//! @brief NCAgf[^MۂɌĂяo܂
		//! @param[in] pSession Mix::Network::ISession C^[tF[X̃|C^
		//! @param[in] pData Mf[^̃|C^
		//! @param[in] size Mf[^̃TCY
		virtual void OnRecive( Mix::Network::ISession* pSession, const void* pData, UInt32 size ) = 0;

		//! @brief T[o[ŃG[ꍇɌĂяo܂
		//! @param[in] err G[ԍ
		virtual void OnError( Mix::Network::RESULT err ) = 0;
		//! @brief ZbVŃG[ۂɌĂяo܂
		//! @param[in] pSession G[ Mix::Network::ISession C^[tF[X̃AhX
		//! @param[in] err G[ԍ
		virtual void OnError( Mix::Network::ISession* pSession, Mix::Network::RESULT err ) = 0;
	};

}}
