#pragma once

//! @file Mix/Network/ITcpServer.h
//! @brief TCPT[o[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Network{


	//! @class ITcpServer
	//! @brief TCPT[o[C^[tF[X
	class ITcpServer : public Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ITcpServer( void ){}

	public:
		//! @brief |[O܂
		//! @note ̃\bhŁuCxgvuMvȂǂsĂ邽߁AKt[sĂ
		virtual void Poll( void ) = 0;

		//! @brief T[o[j܂
		//! @note ̊֐ĂяoƂɂāASɉ邱Ƃł܂B
		virtual void Destroy( void ) = 0;
		//! @brief T[o[̔jԂ擾܂
		//! @return jĂꍇ True Ԃ܂
		virtual Boolean IsDestroy( void ) const = 0;

		//! @brief SĂ̐ڑɃf[^𑗐M܂
		//! @param[in] pData Mf[^
		//! @param[in] dataSize Mf[^̃TCY
		//! @return Mڑ̐Ԃ܂
		virtual UInt32 SendAll( const void* pData, UInt32 dataSize ) = 0;
		//! @brief SẴZbVI܂
		//! @brief IZbV̐Ԃ܂
		virtual UInt32 CloseAll( void ) = 0;

		//! @brief ݊mĂڑ̐擾܂
		//! @return ݊mĂڑ̐Ԃ܂
		virtual UInt32 GetCount( void ) const = 0;
	};

}}
