#pragma once

//! @file Mix/Network/ITcpClient.h
//! @brief TCPNCAgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Network{

	//! @class ITcpClient
	//! @brief TCPNCAgC^[tF[X
	class ITcpClient : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ITcpClient( void ){}

	public:
		//! @brief |[O܂
		//! @note ̃\bhŁuCxgvuMvȂǂ̏sĂ邽߁AKt[sĂB
		virtual void Poll( void ) = 0;

		//! @brief NCAgj܂
		//! @note OɌĂяoƂŁASɏI邱Ƃł܂
		virtual void Destroy( void ) = 0;
		//! @brief NCAg̔jԂ擾܂
		//! @return jĂꍇ True Ԃ܂
		virtual Boolean IsDestroy( void ) const = 0;

		//! @brief T[o[ɐڑ܂
		virtual void Connect( void ) = 0;
		//! @brief T[o[ؒf܂
		virtual void Disconnect( void ) = 0;
		//! @brief T[o[Ƃ̐ڑԂ擾܂
		//! @return T[o[ƐڑĂꍇ True Ԃ܂
		virtual Boolean IsConnected( void ) const = 0;

		//! @brief T[o[Ƀf[^𑗐M܂
		//! @param[in] pData Mf[^̃|C^
		//! @param[in] dataSize Mf[^̃TCY
		//! @return ꍇ True Ԃ܂
		virtual Boolean Send( const void* pData, UInt32 dataSize ) = 0;

		//! @brief b̑MTCY擾܂
		//! @return b̑MTCYԂ܂
		virtual UInt32 GetSendBytesPerSec( void ) const = 0;
		//! @brief b̎MTCY擾܂
		//! @return b̎MTCYԂ܂
		virtual UInt32 GetReceiverBytesPerSec( void ) const = 0;
	};

}}
