#pragma once

//! @file Mix/Network/ISession.h
//! @brief ZVC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Network{

	//! @class ISession
	//! @brief ZbVC^[tF[X
	class ISession : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ISession( void ){}

	public:
		//! @brief ZbVI܂
		//! @note ZbVIƑM͂łȂȂ܂
		virtual void Close( void ) = 0;
		//! @brief ZbV̏Ԃ擾܂
		//! @return ZbVIĂꍇ True Ԃ܂
		virtual Boolean IsClose( void ) const = 0;

		//! @brief ڑĂNCAg̃AhX擾܂
		//! @return AhXԂ܂
		virtual const wchar_t* GetClientAddr( void ) const = 0;

		//! @brief b̑MTCY擾܂
		//! @return MTCYԂ܂
		virtual UInt32 GetSendBytesPerSec( void ) const = 0;
		//! @brief b̎MTCY擾܂
		//! @return MTCYԂ܂
		virtual UInt32 GetReceiverBytesPerSec( void ) const = 0;

		//! @brief [U[f[^ݒ肵܂
		//! @param[in] pData ݒ肷f[^̃|C^Ԃ܂
		virtual void SetUserData( void* pData ) = 0;
		//! @brief [U[f[^擾܂
		//! @return [U[f[^̃|C^Ԃ܂
		virtual void* GetUserData( void ) const = 0;
	};

}}
