#pragma once

//! @file Mix/Network/IManager.h
//! @brief lbg[N}l[WC^[tF[XCNh|t@C

#include "Mix/Reference.h"

namespace Mix{ namespace Network{

	//! @class IManager
	//! @brief lbg[N}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief TCPT[o[쐬܂
		//! @param[in] cfg TCPT[o[̐ݒ\ Mix::Network::TCP_SERVERCONFIG \
		//! @param[out] ppTcpServer 쐬TCPT[o[n Mix::Network::ITcpServer C^[tF[X̃|C^̃AhX
		//! @param[in] debugName TCPT[o[̃fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTcpServer( const Mix::Network::TCP_SERVERCONFIG& cfg, Mix::Network::ITcpServer** ppTcpServer, const wchar_t* debugName = NULL ) = 0;
		//! @brief TCPNCAg쐬܂
		//! @param[in] cfg TCPNCAg̐ݒ\ Mix::Network::TCP_CLIENTCONFIG \
		//! @param[out] ppTcpClient 쐬TCPNCAg\ Mix::Network::ITcpClient C^[tF[X̃|C^̃AhX
		//! @param[in] debugName TCPNCAg̃fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTcpClient( const Mix::Network::TCP_CLIENTCONFIG& cfg, Mix::Network::ITcpClient** ppTcpClient, const wchar_t* debugName = NULL ) = 0;

		//! @brief [JIPAhX擾܂
		//! @return [JIPAhXԂ܂
		virtual const wchar_t* GetLocalIPAddr( void ) const = 0;
	};

}}
