#pragma once

//! @file Mix/Memory/FixedAllocator.h
//! @brief Œ蒷AP[^NXCN[ht@C

#include "Mix/Memory/Allocator.h"

namespace Mix{ namespace Memory{

	//! @class FixedAllocator
	//! @brief Œ蒷AP[^NX
	class _MIX_DLL_API FixedAllocator : public Mix::Memory::Allocator
	{
	private:
		enum VALUE
		{
			STATE_UNUSE	= 0x00,
			STATE_INUSE	= 0x01,

			SIZE_HEADER	= 1,
		};

		struct NODE
		{
			UInt32 sizeUsage;

			UInt8* pBuffer;

			NODE* pPrevL;
			NODE* pNextL;

			NODE* pParentT;
			NODE* pLeftT;
			NODE* pRightT;
		};

	private:
		UInt32 m_BlockSize;
		UInt32 m_UnitSize;
		UInt32 m_UnitCount;
		UInt32 m_UnitNum;
		UInt32 m_UnitMax;
		NODE* m_pAllocateList;
		NODE* m_pFreeTree;

	private:
		NODE* CreateNode( void );

	public:
		//! @brief RXgN^
		//! @param[in] blockSize ubNTCY( oCgP )
		//! @param[in] unitSize jbg( ubN̏W܂ )̃TCY( ubNP )
		//! @param[in] unitNum ftHg̃jbg
		//! @param[in] unitMax ő僆jbg( 0w肵ꍇ͖ɐ܂ )
		FixedAllocator( UInt32 blockSize, UInt32 unitSize, UInt32 unitNum, UInt32 unitMax = 0 );
		//! @brief fXgN^
		virtual ~FixedAllocator( void );

	public:
		//! @brief mۂ܂
		//! @param[in] size mۂ郁̃TCY
		virtual void* Allocate( size_t size );
		//! @brief ܂
		//! @param[in] ptr mۂ郁̃|C^
		virtual void Deallocate( void* ptr );

		//! @brief svȃ܂
		virtual void RunGC( void );
	};

}}
