#pragma once

//! @file Mix/Memory.h
//! @brief CN[ht@C

#include "Mix/Memory/Allocator.h"
#include "Mix/Memory/FixedAllocator.h"
#include "Mix/Memory/IBuffer.h"

namespace Mix{ namespace Memory{

	//! @brief mۂ܂
	//! @param[in] size mۂTCY
	//! @return mۂ̃|C^
	_MIX_DLL_API void* Allocate( size_t size );

	//! @brief Ċmۂ܂
	//! @param[in] ppMemory Ċmۂ郁̃|C^̃AhX
	//! @param[in] size ĊmۂTCY
	//! @return ꍇ True Ԃ܂
	//! @note ĊmۂɎsꍇAw肵͉܂B<br>
	//! uFreevgpĉKv܂B
	_MIX_DLL_API Boolean Reallocate( void** ppMemory, size_t size );

	//! @brief ܂
	//! @param[in] pMemory 郁̃|C^
	_MIX_DLL_API void Free( void* pMemory );

	//! @brief Rs[܂
	//! @param[in] pDstMemory Rs[̃̃|C^
	//! @param[in] pSrcMemory Rs[̃̃|C^
	//! @param[in] size Rs[TCY
	_MIX_DLL_API void Copy( void* pDstMemory, const void* pSrcMemory, size_t size );

	//! @brief ŜɎw肵l݂܂
	//! @param[in] pMemory ̃|C^
	//! @param[in] size ̃TCY
	//! @param[in] fill ɏޒl
	_MIX_DLL_API void Fill( void* pMemory, size_t size, UInt8 fill );

	//! @brief Ŝ 0 ݂܂
	//! @param[in] pMemory ̃|C^
	//! @param[in] size ̃TCY
	_MIX_DLL_API void Zero( void* pMemory, size_t size );

	//! @brief obt@쐬܂
	//! @param[in] size obt@̃TCY
	//! @param[in] pInitialData f[^( NULLw\ )
	//! @param[out] ppBuffer Mix::Memory::IBuffer C^[tF[X̃|C^
	_MIX_DLL_API Boolean CreateBuffer( UInt32 size, const void* pInitialData, Mix::Memory::IBuffer** ppBuffer );
}}
